/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataManager;
import jas2.hist.DataRenderer;
import jas2.hist.FixedHeightPanel;
import jas2.hist.JASHist;
import jas2.hist.JASHist2DHistogramStyle;
import jas2.hist.JASHist2DPropStyle;
import jas2.hist.JASHistData;
import jas2.hist.JASHistPropDataStyle;
import jas2.hist.JASHistPropStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.TwoDDataManager;
import jas2.hist.normalization.Normalizer;
import jas2.util.PropertyPage;
import jas2.util.PropertySite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class JASHistPropData
extends PropertyPage
implements ListSelectionListener,
PropertySite {
    private PropertyPage m_propStyle;
    private JASHistPropDataStyle m_dataStyle;
    private boolean m_init = false;
    private JASHistData m_selected;
    private DefaultListModel m_listModel;
    private JList m_list;
    private JASHist m_jHist;
    private JCheckBox m_normalized;
    private JButton m_normalizationSettings;
    private JASHist2DHistogramStyle m_histStyle;

    public JASHistPropData(DataManager dm) {
        this.setLayout(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        this.m_list.setCellRenderer(DataRenderer.createRenderer());
        this.m_list.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.m_list);
        scroll.setPreferredSize(new Dimension(100, 120));
        this.add((Component)scroll, "West");
        JPanel b = new JPanel();
        FixedHeightPanel df = new FixedHeightPanel(new FlowLayout(0));
        this.m_dataStyle = new JASHistPropDataStyle();
        this.m_dataStyle.setPropertySite(this);
        df.add(this.m_dataStyle);
        this.m_normalized = new JCheckBox("Normalized");
        df.add(this.m_normalized);
        this.m_normalizationSettings = new JButton("Normalization Settings...");
        df.add(this.m_normalizationSettings);
        df.setBorder(BorderFactory.createTitledBorder("Data"));
        b.add(df);
        b.setLayout(new BoxLayout(b, 1));
        this.m_propStyle = dm instanceof TwoDDataManager ? new JASHist2DPropStyle() : new JASHistPropStyle();
        this.m_propStyle.setPropertySite(this);
        b.add(this.m_propStyle);
        b.add(Box.createVerticalGlue());
        this.add((Component)b, "Center");
    }

    @Override
    public String getHelpTopic() {
        return "userInterface.propertiesDialog.dataTab";
    }

    @Override
    public void doDataExchange(boolean set, Object bean) {
        if (!this.m_init) {
            JASHist hist = (JASHist)bean;
            Enumeration e = hist.getDataSources();
            while (e.hasMoreElements()) {
                this.m_listModel.addElement(e.nextElement());
            }
            this.m_selected = (JASHistData)this.m_listModel.elementAt(0);
            this.m_list.setSelectedValue(this.m_selected, true);
            this.m_jHist = hist;
            this.m_init = true;
        }
        if (!set) {
            Normalizer norm = this.m_selected.getNormalization();
            this.m_normalized.setSelected(norm != null);
            this.m_normalizationSettings.setEnabled(norm != null);
        }
        JASHistStyle s = this.m_selected.getStyle();
        this.m_propStyle.doDataExchange(set, s);
        this.m_dataStyle.doDataExchange(set, this.m_selected);
        this.setChanged(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!this.m_init) {
            return;
        }
        this.doDataExchange(true, this.m_jHist);
        this.m_selected = (JASHistData)this.m_list.getSelectedValue();
        this.doDataExchange(false, this.m_jHist);
    }

    @Override
    public void callEnable() {
        this.setChanged(true);
    }
}

