/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.FitAdapter1D;
import jas2.hist.FitFailed;
import jas2.hist.FitUpdate;
import jas2.hist.Fittable1DFunction;
import jas2.hist.XYDataSource;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public abstract class Fitter
extends Observable
implements Observer,
Runnable,
Serializable {
    public static final int FITTING = 0;
    public static final int FIT = 1;
    public static final int FAILED = 2;
    public static final int READYTOFIT = 3;
    public static final int NOTREADYTOFIT = 4;
    public static final int OUTAHERE = 5;
    static final long serialVersionUID = -7769799329320822801L;
    private XYDataSource m_data;
    private Fittable1DFunction m_func;
    private int state = 4;
    private Thread thread;
    private boolean observing = false;

    public abstract double getChiSquared();

    public abstract double[] getParameterSigmas();

    protected abstract void fit(Fittable1DFunction var1, double[] var2, double[] var3, double[] var4) throws FitFailed;

    public void fit() throws FitFailed {
        if (this.state != 3) {
            throw new FitFailed("Not ready to fit");
        }
        this.internalFit();
        this.observeData();
    }

    public synchronized void start() {
        if (this.state == 3) {
            this.thread = new Thread((Runnable)this, "Fit thread");
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.internalFit();
            this.observeData();
        }
        catch (FitFailed fitFailed) {
            Fitter fitter = this;
            synchronized (fitter) {
                this.thread = null;
            }
        }
        finally {
            Fitter fitter = this;
            synchronized (fitter) {
                this.thread = null;
            }
        }
    }

    @Override
    public synchronized void update(Observable obs, Object arg) {
        if (obs == this.m_data) {
            if (this.state == 1) {
                this.setState(3);
            }
            this.start();
        }
    }

    public int getState() {
        return this.state;
    }

    private synchronized void observeData() {
        if (!this.observing && this.m_data instanceof Observable) {
            ((Observable)((Object)this.m_data)).addObserver(this);
        }
    }

    private synchronized void setState(int state) {
        this.state = state;
        this.setChanged();
        this.notifyObservers(new FitUpdate(state));
    }

    private synchronized void setState(int state, FitFailed x) {
        this.state = state;
        this.setChanged();
        this.notifyObservers(new FitUpdate(state, x));
    }

    protected void setPercentComplete(int percent) {
        this.setChanged();
        this.notifyObservers(new FitUpdate(this.state, percent));
    }

    private void internalFit() throws FitFailed {
        this.setState(0);
        try {
            int n = this.m_data.getNPoints();
            double[] x = new double[n];
            double[] y = new double[n];
            double[] yerr = new double[n];
            for (int i = 0; i < n; ++i) {
                x[i] = this.m_data.getX(i);
                y[i] = this.m_data.getY(i);
                yerr[i] = this.m_data.getPlusError(i);
                if (yerr[i] == this.m_data.getMinusError(i)) continue;
                throw new FitFailed("Cannot fit data with asymmetric error bars");
            }
            this.fit(new FitAdapter1D(this.m_func), x, y, yerr);
            this.setState(1);
        }
        catch (FitFailed x) {
            this.setState(2, x);
            throw x;
        }
    }

    public synchronized void setFunction(Fittable1DFunction func) {
        if (this.m_func != null && this.m_func.getFit() == this) {
            this.m_func.clearFit();
        }
        this.m_func = func;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public Fittable1DFunction getFunction() {
        return this.m_func;
    }

    public synchronized void setData(XYDataSource data) {
        if (this.observing) {
            ((Observable)((Object)this.m_data)).deleteObserver(this);
            this.observing = false;
        }
        this.m_data = data;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public XYDataSource getData() {
        return this.m_data;
    }

    protected synchronized void dispose() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.setState(5);
        this.deleteObservers();
        this.setData(null);
        this.setFunction(null);
    }
}

