/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.Basic1DFunction;
import jas2.hist.DataSource;
import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.FitterRegistry;
import jas2.hist.FunctionAdvancedOptions;
import jas2.hist.FunctionFactory;
import jas2.hist.FunctionFactoryError;
import jas2.hist.FunctionRegistry;
import jas2.hist.HistogramUpdate;
import jas2.hist.JASHist;
import jas2.hist.JASHist1DFunctionData;
import jas2.hist.JASHist1DHistogramData;
import jas2.hist.JASHistData;
import jas2.hist.ManagedAxis;
import jas2.hist.OneDDataManager;
import jas2.hist.StatisticsBlock;
import jas2.hist.SupportsFunctions;
import jas2.hist.XYDataSource;
import jas2.plot.DataArea;
import jas2.plot.DateAxis;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class BinnedDataManager
extends OneDDataManager
implements SupportsFunctions {
    private int m_defaultNumberOfBins;
    protected final Vector funcs = new Vector();

    BinnedDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats, int defaultNumberOfBins) {
        super(plot, da, l, stats);
        this.m_defaultNumberOfBins = defaultNumberOfBins;
    }

    @Override
    void XAxisUpdated() {
        JASHistData dw;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            dw = (JASHist1DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            ((JASHist1DHistogramData)dw).setXRange(this.xm.getBins(), this.xLow, this.xHigh);
        }
        e = this.funcs.elements();
        while (e.hasMoreElements()) {
            dw = (JASHist1DFunctionData)e.nextElement();
            if (!dw.isShowing()) continue;
            ((JASHist1DFunctionData)dw).setXRange(this.xLow, this.xHigh);
        }
        this.ym[0].setAttentionNeeded();
        if (this.ym[1] != null) {
            this.ym[1].setAttentionNeeded();
        }
    }

    @Override
    public JASHist1DFunctionData addFunction(Basic1DFunction d) {
        JASHist1DFunctionData dw = new JASHist1DFunctionData(this, d);
        this.funcs.addElement(dw);
        return dw;
    }

    @Override
    public void removeFunction(JASHist1DFunctionData d) {
        d.setShowing(false);
        d.destroy();
        this.funcs.removeElement(d);
        this.plot.setTitle(this.plot.getTitle());
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeAllFunctions();
    }

    @Override
    public void removeAllFunctions() {
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            JASHist1DFunctionData d = (JASHist1DFunctionData)e.nextElement();
            d.setShowing(false);
            d.destroy();
        }
        this.funcs.removeAllElements();
    }

    @Override
    public int numberOfFunctions() {
        return this.funcs.size();
    }

    @Override
    public Enumeration getFunctions() {
        return this.funcs.elements();
    }

    @Override
    public final void update(HistogramUpdate hu, JASHistData data) {
        super.update(hu, data);
    }

    @Override
    public final void update(JASHist1DFunctionData data) {
        SwingUtilities.invokeLater(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.funcs.trimToSize();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.data = new Vector();
        in.defaultReadObject();
    }

    @Override
    void modifyPopupMenu(JPopupMenu menu, Component source) {
        super.modifyPopupMenu(menu, source);
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(new AddFunctionMenu());
        menu.add(new RemoveFunctionMenu());
        menu.add(new FitMenu());
        menu.add(new AdvancedOptionsMenu());
    }

    @Override
    public void fillFunctionMenu(JMenu menu) {
        menu.add(new AddFunctionMenu());
        menu.add(new RemoveFunctionMenu());
        menu.add(new FitMenu());
        menu.add(new AdvancedOptionsMenu());
    }

    @Override
    void computeXAxisRange() {
        if (!this.xm.needsAttention()) {
            return;
        }
        this.xm.payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.xm.getRangeAutomatic()) {
            this.xLow = this.xm.getMin();
            this.xHigh = this.xm.getMax();
            return;
        }
        int nShowing = 0;
        this.xLow = 0.0;
        this.xHigh = 0.0;
        boolean hasRebinnables = false;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist1DHistogramData dw = (JASHist1DHistogramData)e.nextElement();
            if (!dw.isShowing() || Double.isNaN(dw.getXMin())) continue;
            if (nShowing++ == 0) {
                this.xLow = dw.getXMin();
                this.xHigh = dw.getXMax();
            } else {
                this.xLow = Math.min(this.xLow, dw.getXMin());
                this.xHigh = Math.max(this.xHigh, dw.getXMax());
            }
            if (!dw.isRebinnable()) continue;
            hasRebinnables = true;
        }
        if (nShowing == 0) {
            return;
        }
        this.xm.setBinned(hasRebinnables);
        if (!this.xm.getAllowSuppressedZero()) {
            if (this.xLow > 0.0) {
                this.xLow = 0.0;
            }
            if (this.xHigh < 0.0) {
                this.xHigh = 0.0;
            }
        }
        if (this.xHigh <= this.xLow) {
            this.xHigh = this.xLow + 1.0;
        }
        this.calcMinMaxBins(this.xLow, this.xHigh);
    }

    @Override
    void computeYAxisRange() {
        for (int i = 0; i < this.ym.length; ++i) {
            double ymin = 0.0;
            double ymax = 0.0;
            if (this.ym[i] == null || !this.ym[i].needsAttention()) continue;
            this.ym[i].payingAttention();
            DoubleAxis yAxis = (DoubleAxis)this.ym[i].getType();
            if (this.data.isEmpty()) {
                return;
            }
            if (!this.ym[i].getRangeAutomatic()) {
                yAxis.setUseSuggestedRange(false);
                yAxis.getAxis().invalidate();
                Enumeration e = this.data.elements();
                while (e.hasMoreElements()) {
                    JASHist1DHistogramData dw = (JASHist1DHistogramData)e.nextElement();
                    if (!dw.isShowing() || dw.getYAxis() != i) continue;
                    dw.validate();
                }
                continue;
            }
            boolean first = true;
            Enumeration e = this.data.elements();
            while (e.hasMoreElements()) {
                JASHist1DHistogramData dw = (JASHist1DHistogramData)e.nextElement();
                if (!dw.isShowing() || dw.getYAxis() != i) continue;
                if (first) {
                    ymin = dw.getYMin();
                    ymax = dw.getYMax();
                    first = false;
                    continue;
                }
                ymin = Math.min(ymin, dw.getYMin());
                ymax = Math.max(ymax, dw.getYMax());
            }
            if (!this.ym[i].getAllowSuppressedZero()) {
                if (ymin > 0.0) {
                    ymin = 0.0;
                }
                if (ymax < 0.0) {
                    ymax = 0.0;
                }
            }
            if (ymax <= ymin) {
                ymax = ymin + 1.0;
            }
            if (this.ym[i].isLogarithmic()) {
                double min = Double.NaN;
                Enumeration e2 = this.data.elements();
                while (e2.hasMoreElements()) {
                    JASHist1DHistogramData dw = (JASHist1DHistogramData)e2.nextElement();
                    if (!dw.isShowing()) continue;
                    XYDataSource ds = (XYDataSource)dw.getFittableDataSource();
                    for (int j = 0; j < ds.getNPoints(); ++j) {
                        double tmpMin = ds.getY(j) - ds.getMinusError(j);
                        if (!(tmpMin > 0.0)) continue;
                        min = Double.isNaN(min) ? tmpMin : Math.min(tmpMin, min);
                    }
                }
                ymin = Double.isNaN(min) ? Math.max(ymin, 0.5) : 0.8 * min;
                if (!this.ym[i].getAllowSuppressedZero()) {
                    ymin = Math.min(ymin, 0.1);
                }
            }
            double oldYMin = yAxis.getPlotMin();
            double oldYMax = yAxis.getPlotMax();
            if (!(ymin < oldYMin) && !(ymax > oldYMax) && !((ymax - ymin) / (oldYMax - oldYMin) < 0.75)) continue;
            yAxis.setUseSuggestedRange(true);
            yAxis.setMin(ymin);
            yAxis.setMax(ymax);
            yAxis.getAxis().revalidate();
        }
    }

    abstract void calcMinMaxBins(double var1, double var3);

    private final class AdvancedOptionsMenu
    extends JMenu {
        private boolean m_build;

        public AdvancedOptionsMenu() {
            super("Advanced options...");
            this.setMnemonic('o');
            Enumeration e = BinnedDataManager.this.getFunctions();
            this.m_build = false;
            if (e != null) {
                while (e.hasMoreElements()) {
                    if (!(((JASHist1DFunctionData)e.nextElement()).getFunction() instanceof FunctionAdvancedOptions)) continue;
                    this.m_build = true;
                    break;
                }
            }
            this.setEnabled(this.m_build);
        }

        @Override
        protected void fireMenuSelected() {
            if (this.m_build) {
                this.m_build = false;
                this.removeAll();
                Enumeration e = BinnedDataManager.this.getFunctions();
                int i = 0;
                while (e.hasMoreElements()) {
                    Basic1DFunction func = ((JASHist1DFunctionData)e.nextElement()).getFunction();
                    if (!(func instanceof FunctionAdvancedOptions)) continue;
                    this.add(new AdvancedOptionsMenuItem((FunctionAdvancedOptions)((Object)func), ++i));
                }
            }
        }

        private final class AdvancedOptionsMenuItem
        extends JMenuItem {
            private FunctionAdvancedOptions m_function;

            AdvancedOptionsMenuItem(FunctionAdvancedOptions function, int i) {
                super(String.valueOf(i) + " " + ((Basic1DFunction)((Object)function)).getTitle());
                this.m_function = function;
                this.setMnemonic(48 + (char)i);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                this.m_function.openAdvancedDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, BinnedDataManager.this.plot), BinnedDataManager.this.plot);
            }
        }
    }

    private final class FitMenu
    extends JMenu {
        private JASHist1DHistogramData m_selectedDataSet;
        private boolean m_build;

        public FitMenu() {
            super("Fit");
            this.setMnemonic('F');
            this.m_build = false;
            if (BinnedDataManager.this.numberOfDataSources() > 0) {
                Enumeration e = BinnedDataManager.this.getFunctions();
                while (e.hasMoreElements()) {
                    Basic1DFunction func = ((JASHist1DFunctionData)e.nextElement()).getFunction();
                    if (!(func instanceof Fittable1DFunction) || ((Fittable1DFunction)func).getFit() != null) continue;
                    this.m_build = true;
                    break;
                }
            }
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.removeAll();
            this.m_build = false;
            if (BinnedDataManager.this.numberOfDataSources() > 1) {
                int i = 0;
                Enumeration e = BinnedDataManager.this.getDataSources();
                while (e.hasMoreElements()) {
                    this.add(new FitMenuDataMenu((JASHist1DHistogramData)e.nextElement(), ++i));
                }
            } else {
                this.m_selectedDataSet = (JASHist1DHistogramData)BinnedDataManager.this.getDataSources().nextElement();
                Enumeration e = BinnedDataManager.this.getFunctions();
                int i = 0;
                while (e.hasMoreElements()) {
                    Basic1DFunction func = ((JASHist1DFunctionData)e.nextElement()).getFunction();
                    if (!(func instanceof Fittable1DFunction) || ((Fittable1DFunction)func).getFit() != null) continue;
                    this.add(new FitMenuFunctionItem((Fittable1DFunction)func, ++i));
                }
            }
        }

        @Override
        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class FitMenuDataMenu
        extends JMenu {
            private boolean m_built;
            private JASHist1DHistogramData m_data;

            FitMenuDataMenu(JASHist1DHistogramData data, int i) {
                super(String.valueOf(i) + " " + data.getTitle());
                this.m_built = false;
                this.m_data = data;
                this.setMnemonic(48 + (char)i);
            }

            @Override
            protected void fireMenuSelected() {
                FitMenu.this.m_selectedDataSet = this.m_data;
                if (!this.m_built) {
                    this.m_built = true;
                    this.removeAll();
                    Enumeration e = BinnedDataManager.this.getFunctions();
                    int i = 0;
                    while (e.hasMoreElements()) {
                        JASHist1DFunctionData d = (JASHist1DFunctionData)e.nextElement();
                        DataSource f = d.getDataSource();
                        if (!(f instanceof Fittable1DFunction)) continue;
                        this.add(new FitMenuFunctionItem((Fittable1DFunction)f, ++i));
                    }
                }
            }
        }

        private final class FitMenuFunctionItem
        extends JMenuItem {
            private Fittable1DFunction m_func;

            FitMenuFunctionItem(Fittable1DFunction func, int i) {
                super(String.valueOf(i) + " " + func.getTitle());
                this.m_func = func;
                this.setMnemonic(48 + (char)i);
            }

            @Override
            protected void fireActionPerformed(ActionEvent evt) {
                Fitter fitter = FitterRegistry.instance().getDefaultFitter();
                fitter.setFunction(this.m_func);
                fitter.setData((XYDataSource)FitMenu.this.m_selectedDataSet.getFittableDataSource());
                JASHist cfr_ignored_0 = BinnedDataManager.this.plot;
                JASHist.notifyFitListeners(fitter);
                fitter.start();
            }
        }
    }

    private final class RemoveFunctionMenu
    extends JMenu {
        private boolean m_build;
        private RemoveAll m_removeAll;

        public RemoveFunctionMenu() {
            super("Remove function");
            this.setMnemonic('R');
            this.m_removeAll = new RemoveAll();
            this.m_build = BinnedDataManager.this.numberOfFunctions() > 0;
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.m_build = false;
            this.removeAll();
            int i = 0;
            Enumeration e = BinnedDataManager.this.getFunctions();
            while (e.hasMoreElements()) {
                this.add(new RemoveFunctionMenuItem((JASHist1DFunctionData)e.nextElement(), ++i));
            }
            if (i > 1) {
                this.addSeparator();
                this.add(this.m_removeAll);
            }
        }

        @Override
        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class RemoveAll
        extends JMenuItem {
            RemoveAll() {
                super("Remove all");
            }

            @Override
            protected void fireActionPerformed(ActionEvent evt) {
                BinnedDataManager.this.removeAllFunctions();
            }
        }

        private final class RemoveFunctionMenuItem
        extends JMenuItem {
            private JASHist1DFunctionData m_func;

            RemoveFunctionMenuItem(JASHist1DFunctionData func, int i) {
                super(new StringBuffer(String.valueOf(i)).append(' ').append(func.getTitle()).toString());
                this.m_func = func;
                this.setMnemonic(48 + (char)i);
            }

            @Override
            protected void fireActionPerformed(ActionEvent evt) {
                BinnedDataManager.this.removeFunction(this.m_func);
            }
        }
    }

    private final class AddFunctionMenu
    extends JMenu {
        private boolean m_build;

        public AddFunctionMenu() {
            super("Add function");
            this.setMnemonic('A');
            this.m_build = FitterRegistry.instance().getDefaultFitter() != null && FunctionRegistry.instance().size() > 0;
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.removeAll();
            int i = 0;
            Enumeration e = FunctionRegistry.instance().elements();
            while (e.hasMoreElements()) {
                this.add(new AddFunctionMenuItem((FunctionFactory)e.nextElement(), ++i));
            }
            this.m_build = false;
        }

        @Override
        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class AddFunctionMenuItem
        extends JMenuItem {
            private FunctionFactory m_func;

            AddFunctionMenuItem(FunctionFactory func, int i) {
                super(new StringBuffer(String.valueOf(i)).append(' ').append(func.getFunctionName()).toString());
                this.m_func = func;
                this.setMnemonic(48 + (char)i);
            }

            @Override
            protected void fireActionPerformed(ActionEvent evt) {
                try {
                    BinnedDataManager.this.plot.addData(this.m_func.createFunction(BinnedDataManager.this.plot)).show(true);
                }
                catch (FunctionFactoryError ffe) {
                    JOptionPane.showMessageDialog(this, "Could not add function.");
                }
            }
        }
    }

    abstract class AxisListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected double xLowOld;
        protected double grab;
        protected int grabType;
        protected ManagedAxis axis;
        protected Cursor oldCursor;

        AxisListener(ManagedAxis axis) {
            this.axis = axis;
            axis.addMouseListener(this);
            axis.addMouseMotionListener(this);
            axis.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            int min = this.axis.getMinLocation();
            int max = this.axis.getMaxLocation();
            double rgrab = (double)me.getX() / (double)(max - min);
            this.oldCursor = this.axis.getCursor();
            if (rgrab < 0.2) {
                this.grabType = 0;
                this.grab = BinnedDataManager.this.xLow + rgrab * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                this.axis.setCursor(Cursor.getPredefinedCursor(11));
            } else if (rgrab > 0.8) {
                this.grabType = 1;
                this.grab = BinnedDataManager.this.xLow + rgrab * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                this.axis.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                this.grabType = 2;
                this.grab = rgrab;
                this.xLowOld = BinnedDataManager.this.xLow;
                this.axis.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.axis.setCursor(this.oldCursor);
        }
    }

    protected final class DoubleAxisListener
    extends AxisListener {
        private DoubleAxis axisType;

        DoubleAxisListener(ManagedAxis axis) {
            super(axis);
            this.axisType = (DoubleAxis)axis.getType();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            int min = this.axis.getMinLocation();
            int max = this.axis.getMaxLocation();
            double f = (double)me.getX() / (double)(max - min);
            if (this.grabType == 1) {
                BinnedDataManager.this.xHigh = BinnedDataManager.this.xLow + (this.grab - BinnedDataManager.this.xLow) / f;
                this.axisType.setMax(BinnedDataManager.this.xHigh);
            } else if (this.grabType == 0) {
                BinnedDataManager.this.xLow = BinnedDataManager.this.xHigh - (BinnedDataManager.this.xHigh - this.grab) / (1.0 - f);
                this.axisType.setMin(BinnedDataManager.this.xLow);
            } else {
                double off = (this.grab - f) * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                BinnedDataManager.this.xHigh = this.xLowOld + off + BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow;
                BinnedDataManager.this.xLow = this.xLowOld + off;
                this.axisType.setMin(BinnedDataManager.this.xLow);
                this.axisType.setMax(BinnedDataManager.this.xHigh);
            }
            this.axis.setRangeAutomatic(false);
            BinnedDataManager.this.XAxisUpdated();
            BinnedDataManager.this.computeYAxisRange();
            BinnedDataManager.this.da.repaint();
        }
    }

    protected final class DateAxisListener
    extends AxisListener {
        private DateAxis axisType;

        DateAxisListener(ManagedAxis axis) {
            super(axis);
            this.axisType = (DateAxis)axis.getType();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            int min = this.axis.getMinLocation();
            int max = this.axis.getMaxLocation();
            double f = (double)me.getX() / (double)(max - min);
            if (this.grabType == 1) {
                BinnedDataManager.this.xHigh = BinnedDataManager.this.xLow + (this.grab - BinnedDataManager.this.xLow) / f;
                this.axisType.setMax((long)(BinnedDataManager.this.xHigh * 1000.0));
            } else if (this.grabType == 0) {
                BinnedDataManager.this.xLow = BinnedDataManager.this.xHigh - (BinnedDataManager.this.xHigh - this.grab) / (1.0 - f);
                this.axisType.setMin((long)(BinnedDataManager.this.xLow * 1000.0));
            } else {
                double off = (this.grab - f) * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                BinnedDataManager.this.xHigh = this.xLowOld + off + BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow;
                BinnedDataManager.this.xLow = this.xLowOld + off;
                this.axisType.setMin((long)(BinnedDataManager.this.xLow * 1000.0));
                this.axisType.setMax((long)(BinnedDataManager.this.xHigh * 1000.0));
            }
            this.axis.setRangeAutomatic(false);
            BinnedDataManager.this.XAxisUpdated();
            BinnedDataManager.this.computeYAxisRange();
            BinnedDataManager.this.da.repaint();
        }
    }
}

