/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.BadTableHtmlException;
import htmllayout.Cell;
import htmllayout.HtmlLayout;
import htmllayout.Scanner;

class TableParser {
    Scanner in;
    int rows = -1;
    int cols = -1;
    int hgap;
    int vgap;
    int hpad;
    int vpad;
    int horz = 4;
    int vert = 4;
    Cell[][] cells;
    int curRow;
    int curCol;
    int gridcount;
    int cellCount;
    boolean[][] taken;
    static final String[] values = new String[]{"HORZ", "VERT", "ROWS", "COLS", "HGAP", "VGAP", "HPAD", "VPAD", "COLSPAN", "ROWSPAN", "COMPONENT"};
    int pairValue;

    TableParser(Scanner in, boolean eatTable, TableParser parent) {
        this.in = in;
        if (eatTable && (in.scan() != 0 || in.scanU() != 4 || !in.currentString.equals("TABLE"))) {
            this.error("description must start with TABLE tag");
        }
        if (parent != null) {
            this.hgap = parent.hgap;
            this.vgap = parent.vgap;
            this.hpad = parent.hpad;
            this.vpad = parent.vpad;
        }
        this.parseTable();
        this.finishTable();
    }

    int lookup(String[] poss, String value) {
        for (int i = 0; i < poss.length; ++i) {
            if (!poss[i].equals(value)) continue;
            return i;
        }
        this.error("Invalid value " + value);
        return -1;
    }

    int parsePair() {
        int key = this.lookup(values, this.in.currentString);
        this.scan(3);
        this.scan(4);
        if (key == 10) {
            return key;
        }
        if (key < 2) {
            String sval = this.in.currentString.toUpperCase();
            int val = this.lookup(HtmlLayout.ALIGNNAMES, sval);
            if (key == 0 && val > 4 || key == 1 && val < 2) {
                this.error(sval + " illegal value for " + values[key]);
            }
            this.pairValue = val;
            return key;
        }
        try {
            this.pairValue = Integer.parseInt(this.in.currentString);
        }
        catch (NumberFormatException nfe) {
            this.error(values[key] + " value must be an integer");
        }
        return key;
    }

    void parseTable() {
        int tok;
        block10: while ((tok = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 0: {
                    this.horz = this.pairValue;
                    continue block10;
                }
                case 1: {
                    this.vert = this.pairValue;
                    continue block10;
                }
                case 2: {
                    this.rows = this.pairValue;
                    continue block10;
                }
                case 3: {
                    this.cols = this.pairValue;
                    continue block10;
                }
                case 4: {
                    this.hgap = this.pairValue;
                    continue block10;
                }
                case 5: {
                    this.vgap = this.pairValue;
                    continue block10;
                }
                case 6: {
                    this.hpad = this.pairValue;
                    continue block10;
                }
                case 7: {
                    this.vpad = this.pairValue;
                    continue block10;
                }
            }
            this.error("Invalid attribute for TABLE");
        }
        if (tok != 1) {
            this.error("wrong token");
        }
        if (this.cols < 1 || this.rows < 1) {
            this.error("must specify positive rows and columns for TABLE");
        }
        this.cells = new Cell[this.rows][this.cols];
        this.taken = new boolean[this.rows][this.cols];
        while (this.in.scan() == 0 && this.in.scanU() == 4) {
            if (this.in.currentString.equals("TR")) {
                if (!this.parseTR()) continue;
                return;
            }
            if (this.in.currentString.equals("/TABLE")) {
                this.scan(1);
                return;
            }
            this.error("Unexpected tag " + this.in.currentString);
        }
        this.scan(-1);
    }

    boolean parseTR() {
        int tok;
        int curRowVGap = this.vgap;
        if (this.curRow >= this.rows) {
            this.error("Excess rows in table");
        }
        block3: while ((tok = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 5: {
                    curRowVGap = this.pairValue;
                    continue block3;
                }
            }
            this.error("Invalid  attribute for TR");
        }
        if (tok != 1) {
            this.error("wrong token");
        }
        while (this.in.scan() == 0 && this.in.scanU() == 4) {
            if (this.in.currentString.equals("TD")) {
                this.parseTD(curRowVGap);
                if (this.in.lastTok != 4) continue;
            }
            if (this.in.currentString.equals("TR")) {
                this.finishRow(curRowVGap);
                return this.parseTR();
            }
            if (this.in.currentString.equals("/TR")) {
                this.scan(1);
                this.finishRow(curRowVGap);
                return false;
            }
            if (this.in.currentString.equals("/TABLE")) {
                this.scan(1);
                this.finishRow(curRowVGap);
                return true;
            }
            this.error("Unexpected tag " + this.in.currentString);
        }
        this.scan(-1);
        this.finishRow(curRowVGap);
        return true;
    }

    private void finishRow(int curRowVGap) {
        while (this.curCol < this.cols) {
            if (!this.taken[this.curRow][this.curCol]) {
                Cell cell = new Cell(this.hgap, curRowVGap, 0, 0);
                this.addCell(cell);
                continue;
            }
            ++this.curCol;
        }
        this.curCol = 0;
        ++this.curRow;
    }

    private void finishTable() {
        while (this.curRow < this.rows) {
            this.finishRow(this.vgap);
        }
    }

    void parseTD(int curRowVGap) {
        int tok;
        Cell c = new Cell(this.hgap, curRowVGap, this.hpad, this.vpad);
        block11: while ((tok = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 0: {
                    c.hfill = this.pairValue;
                    continue block11;
                }
                case 1: {
                    c.vfill = this.pairValue;
                    continue block11;
                }
                case 4: {
                    c.hgap = this.pairValue;
                    continue block11;
                }
                case 5: {
                    c.vgap = this.pairValue;
                    continue block11;
                }
                case 6: {
                    c.hpad = this.pairValue;
                    continue block11;
                }
                case 7: {
                    c.vpad = this.pairValue;
                    continue block11;
                }
                case 8: {
                    if (this.pairValue < 1) {
                        this.error("colspan must be >= 1");
                    }
                    c.colspan = this.pairValue;
                    continue block11;
                }
                case 9: {
                    if (this.pairValue < 1) {
                        this.error("rowspan must be >= 1");
                    }
                    c.rowspan = this.pairValue;
                    continue block11;
                }
                case 10: {
                    c.name = this.in.currentString;
                    continue block11;
                }
            }
            this.error("Invalid attribute for TR");
        }
        if (tok != 1) {
            this.error("wrong token");
        }
        this.addCell(c);
        tok = this.in.scan();
        if (tok == 4) {
            if (c.name != null) {
                this.error("TDs can only have a component or text");
            }
            c.labelText = this.in.currentString;
            tok = this.in.scan();
        }
        while (true) {
            if (tok == -1) {
                return;
            }
            if (tok != 0 || this.in.scanU() != 4) {
                this.error("Parse error");
            }
            if (this.in.currentString.equals("TD")) {
                this.parseTD(curRowVGap);
                return;
            }
            if (this.in.currentString.equals("/TD")) {
                this.scan(1);
                return;
            }
            if (!this.in.currentString.equals("TABLE")) break;
            if (c.name != null || c.labelText != null) {
                this.error("TDs can't have a component or text with a TABLE");
            }
            c.nested = new HtmlLayout(this);
            tok = this.in.scan();
        }
    }

    private void addCell(Cell c) {
        while (this.taken[this.curRow][this.curCol]) {
            ++this.curCol;
            if (this.curCol != this.cols) continue;
            this.error("excess elements");
        }
        c.row = this.curRow;
        c.col = this.curCol;
        if (c.row + c.rowspan > this.rows || c.col + c.colspan > this.cols) {
            this.error("element exceeds table bounds");
        }
        for (int j = c.row; j < c.row + c.rowspan; ++j) {
            for (int i = c.col; i < c.col + c.colspan; ++i) {
                if (this.taken[j][i]) {
                    this.error("table elements overlap");
                }
                this.taken[j][i] = true;
            }
        }
        this.curCol += c.colspan;
        this.cells[c.row][c.col] = c;
        ++this.cellCount;
    }

    void error(String message) {
        String context = this.in.source.substring(Math.max(0, this.in.pos - 10), Math.min(this.in.pos + 1, this.in.source.length()));
        throw new BadTableHtmlException("Bad html at or before character " + this.in.pos + " : " + message + " : " + context + " <--");
    }

    void scan(int tok) {
        if (this.in.scan() != tok) {
            this.error("wrong token");
        }
    }
}

