/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.Cell;
import htmllayout.HtmlLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HtmlLayoutTest
extends Frame {
    HtmlLayoutTest(String title, String html) {
        super(title);
        HtmlLayout hl = new HtmlLayout(html);
        this.setLayout(hl);
        this.addComps(hl.cells);
    }

    void addComps(Cell[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i].name != null) {
                Button b = new Button(cells[i].name);
                this.add((Component)b, cells[i].name);
                continue;
            }
            if (cells[i].nested == null) continue;
            this.addComps(cells[i].nested.cells);
        }
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            this.hide();
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("HtmlLayoutTest filename [...]");
            System.err.println("\tReads in each file \"filename\" containing table html\n\tand creates a window layed out according to that html.\n\tButtons are created to fill in for the components.");
        }
        for (int i = 0; i < args.length; ++i) {
            RandomAccessFile raf = new RandomAccessFile(args[i], "r");
            byte[] data = new byte[(int)raf.length()];
            raf.readFully(data);
            raf.close();
            HtmlLayoutTest f = new HtmlLayoutTest(args[i], new String(data));
            f.pack();
            f.setVisible(true);
        }
    }
}

