/*
 * Decompiled with CFR 0.152.
 */
package hepjas.io.stdhep.adapter;

import hep.io.stdhep.StdhepEvent;
import hepjas.analysis.EventHeader;
import hepjas.physics.Particle;
import hepjas.physics.ParticleEnumeration;
import hepjas.physics.ParticleProperties;
import hepjas.physics.ParticleType;
import hepjas.physics.ParticleVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class HepEvent
implements EventHeader {
    private StdhepEvent hepevt;
    private HepParticle[] particle;
    private Hashtable m_hash = new Hashtable();

    HepEvent(StdhepEvent hepevt) {
        this.hepevt = hepevt;
        this.particle = new HepParticle[hepevt.getNHEP()];
        this.m_hash.put("MCParticles", new HepParticleVector());
    }

    @Override
    public int getRunNumber() {
        return 0;
    }

    @Override
    public int getEventNumber() {
        return this.hepevt.getNEVHEP();
    }

    @Override
    public Enumeration keys() {
        return this.m_hash.keys();
    }

    @Override
    public Object get(String name) {
        Object result = this.m_hash.get(name);
        if (result == null) {
            throw new RuntimeException("Unknown event component " + name);
        }
        return result;
    }

    @Override
    public void put(String name, Object value) {
        this.m_hash.put(name, value);
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    private final class ParentEnumeration
    implements ParticleEnumeration {
        private int i = 0;
        private int n = 0;
        private int[] id = new int[2];

        ParentEnumeration(int id1, int id2) {
            if (id1 != 0) {
                this.id[this.n++] = id1 - 1;
            }
            if (id2 != 0) {
                this.id[this.n++] = id2 - 1;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.n;
        }

        @Override
        public boolean hasMoreParticles() {
            return this.i < this.n;
        }

        public Object nextElement() {
            return this.nextParticle();
        }

        @Override
        public Particle nextParticle() {
            int index = this.id[this.i++];
            if (HepEvent.this.particle[index] == null) {
                ((HepEvent)HepEvent.this).particle[index] = new HepParticle(index);
            }
            return HepEvent.this.particle[index];
        }
    }

    private final class HepEnumeration
    implements ParticleEnumeration {
        private int i;
        private int n;

        HepEnumeration() {
            this.i = 0;
            this.n = HepEvent.this.hepevt.getNHEP();
        }

        HepEnumeration(int id1, int id2) {
            this.i = id1 - 1;
            this.n = id1 == 0 ? -1 : id2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.n;
        }

        @Override
        public boolean hasMoreParticles() {
            return this.i < this.n;
        }

        public Object nextElement() {
            return this.nextParticle();
        }

        @Override
        public Particle nextParticle() {
            if (HepEvent.this.particle[this.i] == null) {
                ((HepEvent)HepEvent.this).particle[this.i] = new HepParticle(this.i);
            }
            return HepEvent.this.particle[this.i++];
        }
    }

    private final class HepParticle
    implements Particle {
        private int index;

        HepParticle(int i) {
            this.index = i;
        }

        @Override
        public double getPX() {
            return HepEvent.this.hepevt.getPHEP(this.index, 0);
        }

        @Override
        public double getPY() {
            return HepEvent.this.hepevt.getPHEP(this.index, 1);
        }

        @Override
        public double getPZ() {
            return HepEvent.this.hepevt.getPHEP(this.index, 2);
        }

        @Override
        public double getEnergy() {
            return HepEvent.this.hepevt.getPHEP(this.index, 3);
        }

        @Override
        public double getMass() {
            return HepEvent.this.hepevt.getPHEP(this.index, 4);
        }

        @Override
        public double getOriginX() {
            return HepEvent.this.hepevt.getVHEP(this.index, 0);
        }

        @Override
        public double getOriginY() {
            return HepEvent.this.hepevt.getVHEP(this.index, 1);
        }

        @Override
        public double getOriginZ() {
            return HepEvent.this.hepevt.getVHEP(this.index, 2);
        }

        @Override
        public double getProductionTime() {
            return HepEvent.this.hepevt.getVHEP(this.index, 3);
        }

        @Override
        public int getStatusCode() {
            return HepEvent.this.hepevt.getISTHEP(this.index);
        }

        @Override
        public double[] getMomentum() {
            double[] result = new double[]{this.getPX(), this.getPY(), this.getPZ()};
            return result;
        }

        @Override
        public double[] getOrigin() {
            double[] result = new double[]{this.getOriginX(), this.getOriginY(), this.getOriginZ()};
            return result;
        }

        @Override
        public ParticleEnumeration getDaughters() {
            return new HepEnumeration(HepEvent.this.hepevt.getJDAHEP(this.index, 0), HepEvent.this.hepevt.getJDAHEP(this.index, 1));
        }

        @Override
        public Particle getParent() {
            int id1 = HepEvent.this.hepevt.getJMOHEP(this.index, 0);
            int id2 = HepEvent.this.hepevt.getJMOHEP(this.index, 1);
            if (id1 == 0) {
                return null;
            }
            if (id2 != 0) {
                throw new RuntimeException(">1 parent, use getParents() instead of getParent()");
            }
            if (HepEvent.this.particle[--id1] == null) {
                ((HepEvent)HepEvent.this).particle[id1] = new HepParticle(id1);
            }
            return HepEvent.this.particle[id1];
        }

        @Override
        public ParticleEnumeration getParents() {
            return new ParentEnumeration(HepEvent.this.hepevt.getJMOHEP(this.index, 0), HepEvent.this.hepevt.getJMOHEP(this.index, 1));
        }

        @Override
        public ParticleType getType() {
            return ParticleProperties.get(HepEvent.this.hepevt.getIDHEP(this.index));
        }
    }

    private class HepParticleVector
    implements ParticleVector {
        private HepParticleVector() {
        }

        @Override
        public int size() {
            return HepEvent.this.hepevt.getNHEP();
        }

        @Override
        public ParticleEnumeration particles() {
            return new HepEnumeration();
        }
    }
}

