/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.NoSuchBinException;
import hepjas.analysis.partition.Abstract2DPartition;
import hepjas.analysis.partition.BinInfo;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.partition.StatisticsProvider;
import hepjas.analysis.partition.TwoDDataSource;
import hepjas.analysis.partition.TwoDFillable;
import java.util.Date;

public abstract class TwoDDelegatingPartition
extends Abstract2DPartition {
    private BinInfo infoX;
    private BinInfo infoY;
    private TwoDFillable fillable;
    private TwoDDataSource dataSource;
    private StatisticsProvider statisticsProvider;
    static final long serialVersionUID = 3773691152490375678L;

    @Override
    public void fill(double x, double y) {
        this.fillable.fill(x, y);
        this.setDataChanged();
    }

    @Override
    public void fillW(double x, double y, double weight) {
        this.fillable.fillW(x, y, weight);
        this.setDataChanged();
    }

    @Override
    public void fill(Date x, double y) {
        this.fillable.fill(x, y);
        this.setDataChanged();
    }

    @Override
    public void fillW(Date x, double y, double weight) {
        this.fillable.fillW(x, y, weight);
        this.setDataChanged();
    }

    @Override
    public void clear() {
        this.fillable.clear();
        super.clear();
    }

    @Override
    public Statistics getStatistics() {
        return this.statisticsProvider.getStatistics();
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return this.dataSource.hasAsymmetricErrorBars();
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return this.dataSource.hasSimpleQuadraticErrorBars();
    }

    @Override
    public double[][] getPlusErrors() {
        return this.dataSource.getPlusErrors();
    }

    @Override
    public double[][] getMinusErrors() {
        return this.dataSource.getMinusErrors();
    }

    @Override
    public double[][] getBins() {
        this.clearDataChanged();
        return this.dataSource.getBins();
    }

    @Override
    public double getBin(int binX, int binY) throws NoSuchBinException {
        return this.dataSource.getBins()[binX][binY];
    }

    @Override
    public boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    @Override
    public void setXBinning(int bins, double min, double max) {
        this.dataSource.setXBinning(bins, min, max);
    }

    @Override
    public void setYBinning(int bins, double min, double max) {
        this.dataSource.setYBinning(bins, min, max);
    }

    @Override
    public String[] getXAxisLabels() {
        return this.dataSource.getXAxisLabels();
    }

    @Override
    public String[] getYAxisLabels() {
        return this.dataSource.getYAxisLabels();
    }

    @Override
    public int getXAxisType() {
        return this.dataSource.getXAxisType();
    }

    @Override
    public int getYAxisType() {
        return this.dataSource.getYAxisType();
    }

    @Override
    public int getNumberOfXBins() {
        return this.infoX.getNumberOfBins();
    }

    @Override
    public int getNumberOfYBins() {
        return this.infoY.getNumberOfBins();
    }

    @Override
    public double getXMin() {
        return this.infoX.getMin();
    }

    @Override
    public double getYMin() {
        return this.infoY.getMin();
    }

    @Override
    public double getXMax() {
        return this.infoX.getMax();
    }

    @Override
    public double getYMax() {
        return this.infoY.getMax();
    }

    protected void setFillable(TwoDFillable fillable) {
        this.fillable = fillable;
    }

    protected void setDataSource(TwoDDataSource source) {
        this.dataSource = source;
    }

    protected void setStatisticsProvider(StatisticsProvider provider) {
        this.statisticsProvider = provider;
    }

    protected void setBinInfoX(BinInfo info) {
        this.infoX = info;
    }

    protected void setBinInfoY(BinInfo info) {
        this.infoY = info;
    }
}

