/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.PartitionFillException;

public class RMSBinner
implements BinType {
    protected int m_bins;
    protected double[] m_hist;
    protected double[] m_error;
    protected double[] m_n;
    static final long serialVersionUID = -5351379217539362772L;

    public RMSBinner(int bins) {
        if (bins < 0) {
            throw new IllegalArgumentException("bins <= 0");
        }
        this.m_bins = bins;
        this.clear();
    }

    @Override
    public void clear() {
        this.m_n = new double[this.m_bins];
        this.m_hist = new double[this.m_bins];
        this.m_error = new double[this.m_bins];
    }

    @Override
    public void fill(int bin) {
        throw new PartitionFillException();
    }

    @Override
    public void fillW(int bin, double v) {
        int n = bin;
        this.m_n[n] = this.m_n[n] + 1.0;
        int n2 = bin;
        this.m_hist[n2] = this.m_hist[n2] + v;
        int n3 = bin;
        this.m_error[n3] = this.m_error[n3] + v * v;
    }

    @Override
    public double[] getBins() {
        double[] bins = new double[this.m_bins];
        for (int i = 0; i < this.m_bins; ++i) {
            bins[i] = this.m_hist[i] / this.m_n[i];
        }
        return bins;
    }

    @Override
    public double[] getPlusErrors() {
        double[] error = new double[this.m_bins];
        for (int i = 0; i < this.m_bins; ++i) {
            error[i] = Math.sqrt(this.m_error[i] / this.m_n[i] - this.m_hist[i] * this.m_hist[i] / this.m_n[i] / this.m_n[i]);
        }
        return error;
    }

    @Override
    public double[] getMinusErrors() {
        return this.getPlusErrors();
    }

    @Override
    public void setNumberOfBins(int bins) {
        if (bins == this.m_bins) {
            return;
        }
        double[] hist = new double[bins];
        double[] error = new double[bins];
        double[] n = new double[bins];
        System.arraycopy(this.m_hist, 0, hist, 0, Math.min(bins, this.m_bins));
        System.arraycopy(this.m_error, 0, error, 0, Math.min(bins, this.m_bins));
        System.arraycopy(this.m_n, 0, n, 0, Math.min(bins, this.m_bins));
        this.m_hist = hist;
        this.m_error = error;
        this.m_n = n;
        this.m_bins = bins;
    }

    @Override
    public int getNumberOfBins() {
        return this.m_bins;
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return false;
    }
}

