/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.NoSuchBinException;
import hepjas.analysis.Partition;
import hepjas.analysis.partition.OneDDataSource;
import hepjas.analysis.partition.PartitionFillException;
import hepjas.analysis.partition.PartitionNotification;
import hepjas.analysis.partition.RangeChangeListener;
import hepjas.analysis.partition.UnsupportedPartitionMethodException;
import java.util.Date;

public abstract class Abstract1DPartition
extends Partition
implements RangeChangeListener,
OneDDataSource {
    private transient boolean m_dataChanged = false;
    private transient boolean m_rangeChanged = false;
    private transient boolean m_dataChangedNotificationSent = false;
    private transient boolean m_rangeChangedNotificationSent = false;
    private transient boolean m_dataFinalChangedNotificationSent = false;
    private transient boolean m_rangeFinalChangedNotificationSent = false;
    private static final PartitionNotification hd = new PartitionNotification(2, false);
    private static final PartitionNotification hr = new PartitionNotification(4, false);
    private static final PartitionNotification hdr = new PartitionNotification(6, false);
    static final long serialVersionUID = -758403252683365914L;

    @Override
    public void fillW(double x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(int x, double v) {
        this.fill(x, v);
    }

    @Override
    public void fillW(String x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(Date x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(double x) {
        this.fillW(x, 1.0);
    }

    @Override
    public void fill(int x) {
        this.fillW(x, 1.0);
    }

    @Override
    public void fill(String x) {
        this.fillW(x, 1.0);
    }

    @Override
    public void fill(Date x) {
        this.fillW(x, 1.0);
    }

    @Override
    public void fill(double x, double y) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(double x, double y, double weight) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(Date x, double y) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(Date x, double y, double weight) {
        throw new PartitionFillException(this);
    }

    public int getBinAt(double x) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public int getBinAt(int x) throws NoSuchBinException {
        return this.getBinAt((double)x);
    }

    public int getBinAt(String x) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public int getBinAt(Date x) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public double getBin(int bin) throws NoSuchBinException {
        try {
            return this.getBins()[bin];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchBinException();
        }
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return false;
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    public double getPlusError(int bin) {
        try {
            return this.getPlusErrors()[bin];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchBinException();
        }
    }

    public double getMinusError(int bin) {
        try {
            return this.getMinusErrors()[bin];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchBinException();
        }
    }

    public double getError(int bin) {
        try {
            return this.getPlusErrors()[bin];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchBinException();
        }
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public void setBinning(int bins, double min, double max) {
        throw new UnsupportedPartitionMethodException();
    }

    @Override
    public String[] getAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public abstract double[] getBins();

    @Override
    public abstract double[] getPlusErrors();

    @Override
    public abstract double[] getMinusErrors();

    public abstract int getNumberOfBins();

    @Override
    public abstract double getMin();

    @Override
    public abstract double getMax();

    protected final void setDataChanged() {
        this.m_dataChanged = true;
        if (!this.m_dataChangedNotificationSent) {
            this.notifyObservers(hd);
            this.m_dataChangedNotificationSent = true;
        }
    }

    @Override
    public void rangeChanged(double min, double max) {
        this.setRangeChanged();
    }

    protected final void setDataAndRangeChanged() {
        this.m_dataChanged = true;
        this.m_rangeChanged = true;
        if (!this.m_dataChangedNotificationSent || !this.m_rangeChangedNotificationSent) {
            this.notifyObservers(hdr);
            this.m_dataChangedNotificationSent = true;
            this.m_rangeChangedNotificationSent = true;
        }
    }

    protected final void setDataAndRangeChangedNow() {
        this.m_dataChanged = true;
        this.m_rangeChanged = true;
        this.m_dataFinalChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
        this.done();
    }

    protected final void clearDataChanged() {
        this.m_dataChanged = false;
        this.m_dataChangedNotificationSent = false;
        this.m_dataFinalChangedNotificationSent = false;
    }

    protected final void setRangeChanged() {
        this.m_rangeChanged = true;
        if (!this.m_rangeChangedNotificationSent) {
            this.notifyObservers(hr);
            this.m_rangeChangedNotificationSent = true;
        }
    }

    protected final void clearRangeChanged() {
        this.m_rangeChanged = false;
        this.m_rangeChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
    }

    @Override
    public void clear() {
        this.setDataAndRangeChangedNow();
    }

    @Override
    public void done() {
        int flag = 0;
        if (this.m_dataChanged && !this.m_dataFinalChangedNotificationSent) {
            this.m_dataFinalChangedNotificationSent = true;
            flag |= 2;
        }
        if (this.m_rangeChanged && !this.m_rangeFinalChangedNotificationSent) {
            this.m_rangeFinalChangedNotificationSent = true;
            flag |= 4;
        }
        if (flag != 0) {
            this.notifyObservers(new PartitionNotification(flag, true));
        }
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }
}

