/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.AbstractNamedObject;
import hepjas.analysis.Folder;
import hepjas.analysis.Histogram;
import hepjas.analysis.PlotFolder;
import hepjas.analysis.peer.Peer;
import hepjas.analysis.peer.PlotPeer;
import java.util.Vector;

public class Plot
extends AbstractNamedObject {
    private transient PlotPeer m_peer;
    private Vector m_histograms = new Vector();
    private double m_x;
    private double m_y;
    private double m_width;
    private double m_height;
    static final long serialVersionUID = 796153489222271101L;

    public Plot(String name) {
        this(name, PlotFolder.getDefaultFolder());
    }

    public Plot(String name, Folder parent) {
        super(name, parent);
    }

    public void add(Histogram h) {
        if (!this.m_histograms.contains(h)) {
            this.m_histograms.addElement(h);
            if (this.m_peer != null) {
                this.m_peer.addNotify(h);
            }
        }
    }

    public int getNHistograms() {
        return this.m_histograms.size();
    }

    public Histogram getHistogram(int index) {
        return (Histogram)this.m_histograms.elementAt(index);
    }

    public void remove(Histogram h) {
        if (this.m_histograms.removeElement(h) && this.m_peer != null) {
            this.m_peer.removeNotify(h);
        }
    }

    public void clear() {
        if (!this.m_histograms.isEmpty()) {
            this.m_histograms.removeAllElements();
            if (this.m_peer != null) {
                this.m_peer.clearNotify();
            }
        }
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    @Override
    void setPeer(Peer peer) {
        this.m_peer = (PlotPeer)peer;
    }

    @Override
    Peer getPeer() {
        return this.m_peer;
    }

    @Override
    protected Folder getDefaultParent() {
        return PlotFolder.getDefaultFolder();
    }

    public String toString() {
        return "Plot: " + this.getName();
    }
}

