/*
 * Decompiled with CFR 0.152.
 */
import jscl.text.ParseException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class presentationTest
extends test {
    public static Test suite() {
        return new TestSuite(presentationTest.class);
    }

    public void test1() throws ParseException {
        presentationTest.assertEquals((String)"{1-4*x^2+x^4, 4*x-x^3-y}", (String)presentationTest.expand("groebner({x^2 + y^2 - 4, x*y - 1}, {x, y})"));
    }

    public void test2() throws ParseException {
        presentationTest.assertEquals((String)"{{-1+a[0][0]+a[1][0]*y, a[0][1]+a[1][1]*y},\n{a[1][0]+a[0][0]*x, -1+a[1][1]+a[0][1]*x}}", (String)presentationTest.expand("matrix(\n{{1, y},\n{x, 1}},{{a[0][0], a[0][1]},\n        {a[1][0], a[1][1]}})-{{1, 0},\n                             {0, 1}}"));
    }

    public void test3() throws ParseException {
        presentationTest.assertEquals((String)"{1-a[0][0]+x*y*a[0][0], y*a[0][0]+a[0][1], x*a[0][0]+a[1][0], a[0][0]-a[1][1]}", (String)presentationTest.expand("groebner({-1+a[0][0]+a[1][0]*y,\na[0][1]+a[1][1]*y,\na[1][0]+a[0][0]*x,\n-1+a[1][1]+a[0][1]*x},\n{x, y, a[0][0], a[0][1], a[1][0], a[1][1]})"));
    }

    public void test4() throws ParseException {
        presentationTest.assertEquals((String)"{1-1/(1-x*y)+1/(1-x*y)*x*y, 1/(1-x*y)-a[0][0], 1/(1-x*y)*y+a[0][1], 1/(1-x*y)*x+a[1][0], 1/(1-x*y)-a[1][1]}", (String)presentationTest.expand("groebner({1-a[0][0]+x*y*a[0][0],\ny*a[0][0]+a[0][1],\nx*a[0][0]+a[1][0],\na[0][0]-a[1][1],\n1/(1-x*y)*(1-x*y)-1},\n{1/(1-x*y), x, y, a[0][0], a[0][1], a[1][0], a[1][1]})"));
    }

    public void test5() throws ParseException {
        presentationTest.assertEquals((String)"{{1/(1-x*y), -y*1/(1-x*y)},\n{-x*1/(1-x*y), 1/(1-x*y)}}", (String)presentationTest.expand("{{1/(1-x*y), -1/(1-x*y)*y},\n{-1/(1-x*y)*x, 1/(1-x*y)}}"));
    }

    public void test6() throws ParseException {
        presentationTest.assertEquals((String)"x1*x2+y1*y2+z1*z2", (String)presentationTest.expand("{x1,y1,z1}*{x2,y2,z2}"));
    }

    public void test7() throws ParseException {
        presentationTest.assertEquals((String)"{-y2*z1+y1*z2, x2*z1-x1*z2, -x2*y1+x1*y2}", (String)presentationTest.expand("vector({x1,y1,z1},{x2,y2,z2})"));
    }

    public void test8() throws ParseException {
        presentationTest.assertEquals((String)"{{a},\n{b},\n{c}}", (String)presentationTest.expand("tran({{a,b,c}})"));
    }

    public void test9() throws ParseException {
        presentationTest.assertEquals((String)"a+d", (String)presentationTest.expand("trace({{a,b},{c,d}})"));
    }

    public void test10() throws ParseException {
        presentationTest.assertEquals((String)"-b*c+a*d", (String)presentationTest.expand("det({{a,b},{c,d}})"));
    }

    public void test11() throws ParseException {
        presentationTest.assertEquals((String)"root[0](c, b, a)", (String)presentationTest.expand("solve(c+b*x+a*x^2,x)"));
    }

    public void test12() throws ParseException {
        presentationTest.assertEquals((String)"1/a^2", (String)presentationTest.expand("subst(1/x^2,x,a)"));
    }

    public void test13() throws ParseException {
        presentationTest.assertEquals((String)"-1", (String)presentationTest.simplify("exp(sqrt(-1)*pi)"));
    }

    public void test14() throws ParseException {
        String s = "(1/2)^2*(1/exp(sqrt(-1)*x))^2+(1/2)^2*sqrt(-1)^2*(1/exp(sqrt(-1)*x))^2+2*(1/2)^2*1/exp(sqrt(-1)*x)*exp(sqrt(-1)*x)-2*(1/2)^2*sqrt(-1)^2*1/exp(sqrt(-1)*x)*exp(sqrt(-1)*x)+(1/2)^2*exp(sqrt(-1)*x)^2+(1/2)^2*sqrt(-1)^2*exp(sqrt(-1)*x)^2";
        presentationTest.assertEquals((String)s, (String)presentationTest.elementary("cos(x)^2+sin(x)^2"));
        presentationTest.assertEquals((String)"1", (String)presentationTest.simplify(s));
    }

    public void test15() throws ParseException {
        presentationTest.assertEquals((String)"-f'(x)*sin(f(x))", (String)presentationTest.expand("d(cos(f(x)),x)"));
        presentationTest.assertEquals((String)"-f'(x)^2*cos(f(x))-f''(x)*sin(f(x))", (String)presentationTest.expand("d(-f'(x)*sin(f(x)),x)"));
    }

    public void test16() throws ParseException {
        String s = "{f{1, 0, 0}(x, y, z), f{0, 1, 0}(x, y, z), f{0, 0, 1}(x, y, z)}";
        presentationTest.assertEquals((String)s, (String)presentationTest.expand("grad(f(x,y,z),{x,y,z})"));
        presentationTest.assertEquals((String)"{0, 0, 0}", (String)presentationTest.expand("curl(" + s + ",{x,y,z})"));
        presentationTest.assertEquals((String)"f{2, 0, 0}(x, y, z)+f{0, 2, 0}(x, y, z)+f{0, 0, 2}(x, y, z)", (String)presentationTest.expand("diverg(grad(f(x,y,z),{x,y,z}),{x,y,z})"));
        presentationTest.assertEquals((String)"{0, 0, 0}", (String)presentationTest.expand("curl(grad(f(x,y,z),{x,y,z}),{x,y,z})"));
    }

    public void test17() throws ParseException {
        String s = "1+x+1/2*x^2+1/6*x^3+1/24*x^4";
        presentationTest.assertEquals((String)s, (String)presentationTest.expand("sum(d(exp(x),x,0,i)/i!*(x-0)^i,i,0,4)"));
        presentationTest.assertEquals((String)"(24+24*x+12*x^2+4*x^3+x^4)/24", (String)presentationTest.simplify(s));
    }

    public void test18() throws ParseException {
        String s = "1/3*t^3";
        presentationTest.assertEquals((String)s, (String)presentationTest.expand("integral(x^2,x,0,t)"));
        presentationTest.assertEquals((String)"t^3/3", (String)presentationTest.simplify(s));
    }

    public void test19() throws ParseException {
        presentationTest.assertEquals((String)"root[0](1, 0, 4)*log(1-2*x*root[0](1, 0, 4))+root[1](1, 0, 4)*log(1-2*x*root[1](1, 0, 4))", (String)presentationTest.expand("integral(1/(1+x^2),x)"));
    }

    public void test20() throws ParseException {
        presentationTest.assertEquals((String)"{man+man*mortal, sokrates+man*sokrates, sokrates+mortal*sokrates}", (String)presentationTest.expand("groebner({sokrates*(1+man),\nman*(1+mortal)},\n{man, mortal, sokrates},lex,2)"));
    }

    public void test21() throws ParseException {
        presentationTest.assertEquals((String)"<math><mrow><msup><mi>x</mi><mn>2</mn></msup><msup><mi>y</mi><mn>2</mn></msup></mrow></math>", (String)presentationTest.toMathML("x^2*y^2"));
    }
}

