/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jscl.math.Debug;
import jscl.math.polynomial.DegreeOrdering;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.Pair;
import jscl.math.polynomial.groebner.ReducedRowEchelonForm;
import jscl.math.polynomial.groebner.Standard;

class Block
extends Standard {
    boolean degree;

    Block(Ordering ordering, int flags) {
        super(flags);
        this.degree = ordering instanceof DegreeOrdering;
    }

    @Override
    void compute() {
        Debug.println("compute");
        int degree = 0;
        while (!this.pairs.isEmpty()) {
            ArrayList<Pair> list = new ArrayList<Pair>();
            for (Pair pa : this.pairs.keySet()) {
                int d;
                int n = d = (this.flags & 0x800) > 0 ? pa.sugar : pa.scm.degree();
                if (degree == 0) {
                    degree = d;
                } else if (d > degree || !this.degree) break;
                list.add(pa);
            }
            this.process(list);
            this.remove(list);
            degree = 0;
        }
    }

    @Override
    void add(List list) {
        super.add(ReducedRowEchelonForm.compute(list));
    }

    void process(List pairs) {
        ArrayList<Polynomial> list = new ArrayList<Polynomial>();
        for (Pair pa : pairs) {
            if (this.criterion(pa)) continue;
            Polynomial p = Block.reduce(pa, this.polys);
            if (p.signum() != 0) {
                list.add(p);
            }
            ++this.npairs;
        }
        this.add(list);
    }

    void remove(List pairs) {
        Iterator it = pairs.iterator();
        while (it.hasNext()) {
            this.remove((Pair)it.next());
        }
    }
}

