/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.function.Inv;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.SquarefreeDecomposition;
import jscl.math.polynomial.Term;

public class UnivariatePolynomial
extends Polynomial {
    protected final Variable variable;
    Generic[] content = new Generic[8];
    int degree;

    protected UnivariatePolynomial(Variable variable) {
        this(variable, null);
    }

    UnivariatePolynomial(Variable variable, Generic coefFactory) {
        super(Monomial.factory(new Variable[]{variable}), coefFactory);
        this.variable = variable;
    }

    public Variable variable() {
        return this.variable;
    }

    @Override
    public int size() {
        return this.degree + 1;
    }

    @Override
    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    Term term(int n) {
        return new Term(this.monomial(Literal.valueOf(this.variable, n)), this.get(n));
    }

    int indexOf(Monomial monomial, boolean direction) {
        if (monomial == null) {
            return direction ? this.degree + 1 : 0;
        }
        return monomial.degree();
    }

    @Override
    public Polynomial add(Polynomial polynomial) {
        int d;
        UnivariatePolynomial p = this.newinstance();
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        for (int i = d = Math.max(this.degree, q.degree); i >= 0; --i) {
            p.put(i, this.get(i).add(q.get(i)));
        }
        return p;
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        int d;
        UnivariatePolynomial p = this.newinstance();
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        for (int i = d = Math.max(this.degree, q.degree); i >= 0; --i) {
            p.put(i, this.get(i).subtract(q.get(i)));
        }
        return p;
    }

    @Override
    public Polynomial multiply(Polynomial polynomial) {
        UnivariatePolynomial p = this.newinstance();
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        for (int i = this.degree; i >= 0; --i) {
            for (int j = q.degree; j >= 0; --j) {
                p.put(i + j, this.get(i).multiply(q.get(j)));
            }
        }
        return p;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        UnivariatePolynomial p = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            p.put(i, this.get(i).multiply(generic));
        }
        return p;
    }

    public Polynomial multiply(Monomial monomial, Generic generic) {
        int i;
        UnivariatePolynomial p = this.newinstance();
        int d = monomial.degree();
        for (i = this.degree; i >= 0; --i) {
            p.put(i + d, this.get(i).multiply(generic));
        }
        for (i = d - 1; i >= 0; --i) {
            p.put(i, JSCLInteger.valueOf(0L));
        }
        return p;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        return this.multiply(monomial, JSCLInteger.valueOf(1L));
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        UnivariatePolynomial p = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            p.put(i, this.get(i).divide(generic));
        }
        return p;
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        int i;
        UnivariatePolynomial p = this.newinstance();
        int d = monomial.degree();
        for (i = d - 1; i >= 0; --i) {
            if (this.get(i).signum() == 0) continue;
            throw new NotDivisibleException();
        }
        for (i = this.degree; i >= d; --i) {
            p.put(i - d, this.get(i));
        }
        return p;
    }

    @Override
    public Polynomial[] divideAndRemainder(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] p = new UnivariatePolynomial[]{this.newinstance(), this};
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        if (p[1].signum() == 0) {
            return p;
        }
        for (int i = ((UnivariatePolynomial)p[1]).degree - q.degree; i >= 0; --i) {
            ((UnivariatePolynomial)p[0]).put(i, ((UnivariatePolynomial)p[1]).get(i + q.degree).divide(q.get(q.degree)));
            UnivariatePolynomial r = this.newinstance();
            for (int j = i + q.degree - 1; j >= 0; --j) {
                Generic a = ((UnivariatePolynomial)p[1]).get(j);
                r.put(j, a.subtract(q.get(j - i).multiply(((UnivariatePolynomial)p[0]).get(i))));
            }
            p[1] = r;
        }
        return p;
    }

    @Override
    public Polynomial remainderUpToCoefficient(Polynomial polynomial) throws ArithmeticException {
        UnivariatePolynomial p = this;
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        if (p.signum() == 0) {
            return p;
        }
        for (int i = p.degree - q.degree; i >= 0; --i) {
            UnivariatePolynomial r = this.newinstance();
            for (int j = i + q.degree - 1; j >= 0; --j) {
                Generic a = p.get(j).multiply(q.get(q.degree));
                r.put(j, a.subtract(q.get(j - i).multiply(p.get(i + q.degree))));
            }
            p = r;
        }
        return p;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        UnivariatePolynomial p = this;
        UnivariatePolynomial q = (UnivariatePolynomial)polynomial;
        if (p.signum() == 0) {
            return q;
        }
        if (q.signum() == 0) {
            return p;
        }
        if (p.degree < q.degree) {
            UnivariatePolynomial r = p;
            p = q;
            q = r;
        }
        int d = p.degree - q.degree;
        Generic phi = JSCLInteger.valueOf(-1L);
        Generic beta = JSCLInteger.valueOf(-1L).pow(d + 1);
        Polynomial[] a1 = p.gcdAndNormalize();
        Polynomial[] a2 = q.gcdAndNormalize();
        Generic gcd1 = a1[0].genericValue();
        Generic gcd2 = a2[0].genericValue();
        p = (UnivariatePolynomial)a1[1];
        q = (UnivariatePolynomial)a2[1];
        while (q.degree > 0) {
            UnivariatePolynomial r = (UnivariatePolynomial)p.remainderUpToCoefficient(q).divide(beta);
            phi = d > 1 ? q.get(q.degree).negate().pow(d).divide(phi.pow(d - 1)) : q.get(q.degree).negate().pow(d).multiply(phi.pow(1 - d));
            p = q;
            q = r;
            d = p.degree - q.degree;
            beta = p.get(p.degree).negate().multiply(phi.pow(d));
        }
        if (q.signum() == 0) {
            p = (UnivariatePolynomial)p.normalize();
        } else {
            p = this.newinstance();
            p.put(0, JSCLInteger.valueOf(1L));
        }
        return p.multiply(gcd1.gcd(gcd2));
    }

    @Override
    public Generic gcd() {
        Generic a = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.degree; i >= 0; --i) {
            a = a.gcd(this.get(i));
        }
        return a.signum() == this.signum() ? a : a.negate();
    }

    @Override
    public Monomial monomialGcd() {
        return this.monomial(this.tail());
    }

    @Override
    public int degree() {
        return this.degree;
    }

    public UnivariatePolynomial valueof(Generic[] generic) {
        UnivariatePolynomial p = this.newinstance();
        p.init(generic);
        return p;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Polynomial valueof(Generic generic) {
        UnivariatePolynomial p = this.newinstance();
        p.init(generic);
        return p;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Polynomial freeze() {
        return this;
    }

    @Override
    public Term head() {
        return this.term(this.degree);
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        return this.term(monomial.degree()).coef();
    }

    public Polynomial reduce(Generic generic, Monomial monomial, Polynomial polynomial, boolean inPlace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic genericValue() {
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = this.degree; i >= 0; --i) {
            Expression a = this.get(i).expressionValue();
            s = ((Generic)s).add(i > 0 ? ((Generic)a).multiply(Expression.valueOf(Literal.valueOf(this.variable, i))) : a);
        }
        return s;
    }

    @Override
    public Generic[] elements() {
        Generic[] a = new Generic[this.degree + 1];
        for (int i = this.degree; i >= 0; --i) {
            a[i] = this.get(i);
        }
        return a;
    }

    public UnivariatePolynomial derivative(Variable variable) {
        return (UnivariatePolynomial)this.derivative().multiply(this.variable.derivative(variable));
    }

    public Generic substitute(Generic generic) {
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = this.degree; i >= 0; --i) {
            s = ((Generic)s).add(this.get(i).multiply(generic.pow(i)));
        }
        return s;
    }

    public Generic solve() {
        if (this.degree == 1) {
            return this.get(0).multiply(new Inv(this.get(1)).evaluate()).negate();
        }
        return null;
    }

    public Generic[] identification(UnivariatePolynomial polynomial) {
        UnivariatePolynomial r;
        UnivariatePolynomial p = this;
        UnivariatePolynomial q = polynomial;
        if (p.degree < q.degree || p.degree == 0 && q.signum() == 0) {
            r = p;
            p = q;
            q = r;
        }
        r = (UnivariatePolynomial)p.remainderUpToCoefficient(q);
        Generic[] a = new Generic[r.degree + 1];
        for (int i = r.degree; i >= 0; --i) {
            a[r.degree - i] = r.get(i);
        }
        return a;
    }

    public Generic resultant(UnivariatePolynomial polynomial) {
        UnivariatePolynomial p = this;
        UnivariatePolynomial q = polynomial;
        if (p.degree < q.degree || p.degree == 0 && q.signum() == 0) {
            UnivariatePolynomial r = p;
            p = q;
            q = r;
        }
        int d = p.degree - q.degree;
        Generic phi = JSCLInteger.valueOf(-1L);
        Generic beta = JSCLInteger.valueOf(-1L).pow(d + 1);
        while (q.degree > 0) {
            UnivariatePolynomial r = (UnivariatePolynomial)p.remainderUpToCoefficient(q).divide(beta);
            phi = d > 1 ? q.get(q.degree).negate().pow(d).divide(phi.pow(d - 1)) : q.get(q.degree).negate().pow(d).multiply(phi.pow(1 - d));
            p = q;
            q = r;
            d = p.degree - q.degree;
            beta = p.get(p.degree).negate().multiply(phi.pow(d));
        }
        return q.get(0);
    }

    public UnivariatePolynomial[] remainderSequence(UnivariatePolynomial polynomial) {
        UnivariatePolynomial p = this;
        UnivariatePolynomial q = polynomial;
        if (p.degree < q.degree || p.degree == 0 && q.signum() == 0) {
            UnivariatePolynomial r = p;
            p = q;
            q = r;
        }
        UnivariatePolynomial[] s = new UnivariatePolynomial[q.degree + 1];
        s[q.degree] = q;
        int d = p.degree - q.degree;
        Generic phi = JSCLInteger.valueOf(-1L);
        Generic beta = JSCLInteger.valueOf(-1L).pow(d + 1);
        while (q.degree > 0) {
            UnivariatePolynomial r = (UnivariatePolynomial)p.remainderUpToCoefficient(q).divide(beta);
            phi = d > 1 ? q.get(q.degree).negate().pow(d).divide(phi.pow(d - 1)) : q.get(q.degree).negate().pow(d).multiply(phi.pow(1 - d));
            p = q;
            s[q.degree] = q = r;
            d = p.degree - q.degree;
            beta = p.get(p.degree).negate().multiply(phi.pow(d));
        }
        return s;
    }

    public UnivariatePolynomial squarefree() {
        return (UnivariatePolynomial)this.divide(this.gcd(this.derivative()));
    }

    public UnivariatePolynomial[] squarefreeDecomposition() {
        return SquarefreeDecomposition.compute(this);
    }

    public UnivariatePolynomial antiderivative() {
        UnivariatePolynomial p = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            p.put(i + 1, this.get(i).multiply(new Inv(JSCLInteger.valueOf(i + 1)).evaluate()));
        }
        return p;
    }

    public UnivariatePolynomial derivative() {
        UnivariatePolynomial p = this.newinstance();
        for (int i = this.degree - 1; i >= 0; --i) {
            p.put(i, this.get(i + 1).multiply(JSCLInteger.valueOf(i + 1)));
        }
        return p;
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        int d;
        UnivariatePolynomial p = (UnivariatePolynomial)polynomial;
        for (int i = d = Math.max(this.degree, p.degree); i >= 0; --i) {
            Generic a2;
            Generic a1 = this.get(i);
            int c = a1.compareTo(a2 = p.get(i));
            if (c < 0) {
                return -1;
            }
            if (c <= 0) continue;
            return 1;
        }
        return 0;
    }

    void init(Generic[] generic) {
        for (int i = 0; i < generic.length; ++i) {
            this.put(i, this.coefficient(generic[i]));
        }
    }

    void init(Expression expression) {
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            Monomial m = this.monomial(l);
            if ((l = l.divide(m.literalValue())).degree() > 0) {
                this.put(m.degree(), this.coefficient(en.multiply(Expression.valueOf(l))));
                continue;
            }
            this.put(m.degree(), this.coefficient(en));
        }
    }

    protected void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            this.put(0, this.coefficient(generic));
        }
    }

    void put(int n, Generic generic) {
        Generic a = generic.add(this.get(n));
        if (a.signum() == 0) {
            if (n <= this.degree) {
                this.content[n] = null;
            }
            if (n == this.degree) {
                while (n > 0 && this.content[n] == null) {
                    --n;
                }
                this.degree = n;
            }
        } else {
            if (n >= this.content.length) {
                this.resize(n);
            }
            this.content[n] = a;
            this.degree = Math.max(this.degree, n);
        }
    }

    void resize(int n) {
        int length;
        for (length = this.content.length << 1; n >= length; length <<= 1) {
        }
        Generic[] content = new Generic[length];
        System.arraycopy(this.content, 0, content, 0, this.content.length);
        this.content = content;
    }

    public Generic get(int n) {
        JSCLInteger a = n < 0 || n > this.degree ? null : this.content[n];
        return a == null ? JSCLInteger.valueOf(0L) : a;
    }

    protected UnivariatePolynomial newinstance() {
        return new UnivariatePolynomial(this.variable, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            if (direction) {
                this.index = UnivariatePolynomial.this.indexOf(current, true);
            } else {
                this.index = UnivariatePolynomial.this.indexOf(current, false);
                if (current != null && UnivariatePolynomial.this.get(this.index).signum() != 0) {
                    ++this.index;
                }
            }
            this.seek();
        }

        void seek() {
            if (this.direction) {
                while (this.index > 0 && UnivariatePolynomial.this.get(this.index).signum() == 0) {
                    --this.index;
                }
            } else {
                while (this.index <= UnivariatePolynomial.this.degree && UnivariatePolynomial.this.get(this.index).signum() == 0) {
                    ++this.index;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index <= UnivariatePolynomial.this.degree;
        }

        public Object next() {
            Term t = this.direction ? UnivariatePolynomial.this.term(--this.index) : UnivariatePolynomial.this.term(this.index++);
            this.seek();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

