/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public abstract class Operator
extends Variable {
    protected Generic[] parameter;

    public Operator(String name, Generic[] parameter) {
        super(name);
        this.parameter = parameter;
    }

    public Generic[] parameters() {
        return this.parameter;
    }

    public abstract Generic compute();

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Operator v = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        if (v.isIdentity(variable)) {
            return generic;
        }
        return v.compute();
    }

    @Override
    public Generic expand() {
        Operator v = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].expand();
        }
        return v.compute();
    }

    @Override
    public Generic factorize() {
        Operator v = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].factorize();
        }
        return v.expressionValue();
    }

    @Override
    public Generic elementary() {
        Operator v = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].elementary();
        }
        return v.expressionValue();
    }

    @Override
    public Generic simplify() {
        Operator v = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].simplify();
        }
        return v.expressionValue();
    }

    @Override
    public Generic numeric() {
        throw new ArithmeticException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        Operator v = (Operator)variable;
        c = this.name.compareTo(v.name);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, v.parameter);
    }

    protected static Variable[] variables(Generic generic) throws NotVariableException {
        Generic[] element = ((JSCLVector)generic).elements();
        Variable[] variable = new Variable[element.length];
        for (int i = 0; i < element.length; ++i) {
            variable[i] = element[i].variableValue();
        }
        return variable;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String toJava() {
        throw new ArithmeticException();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.nameToMathML(element);
        } else {
            e1 = element.element("msup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i].toMathML(e1, null);
        }
        element.appendChild(e1);
    }
}

