/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.hyperbolic;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Trigonometric;
import jscl.math.function.hyperbolic.Acosh;
import jscl.math.function.hyperbolic.Sinh;

public class Cosh
extends Trigonometric {
    public Cosh(Generic generic) {
        super("cosh", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Sinh(this.parameter[0]).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return new Sinh(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Cosh(this.parameter[0].negate()).evaluate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Exp(this.parameter[0]).evalelem().add(new Exp(this.parameter[0].negate()).evalelem()).multiply(Constant.half);
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Cosh(this.parameter[0].negate()).evaluate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Acosh) {
                Generic[] g = ((Acosh)v).parameters();
                return g[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic a, Generic b) {
        return new Cosh(a).evalsimp().multiply(new Cosh(b).evalsimp()).add(new Sinh(a).evalsimp().multiply(new Sinh(b).evalsimp()));
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).cosh();
    }

    @Override
    protected Variable newinstance() {
        return new Cosh(null);
    }
}

