/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Function;
import jscl.math.function.Sgn;
import jscl.math.function.Sqrt;
import jscl.mathml.MathML;

public class Abs
extends Function {
    public Abs(Generic generic) {
        super("abs", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return Constant.half.multiply(this.parameter[0]).multiply(new Abs(this.parameter[0]).evaluate());
    }

    @Override
    public Generic derivative(int n) {
        return new Sgn(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Abs(this.parameter[0].negate()).evaluate();
        }
        try {
            return this.parameter[0].integerValue().abs();
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return new Sqrt(this.parameter[0].pow(2)).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Abs(this.parameter[0].negate()).evalsimp();
        }
        try {
            return this.parameter[0].integerValue().abs();
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Abs) {
                    Function f = (Function)v;
                    return f.evalsimp();
                }
                if (v instanceof Sgn) {
                    return JSCLInteger.valueOf(1L);
                }
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).abs();
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".abs()");
        return buffer.toString();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mfenced");
        e1.setAttribute("open", "|");
        e1.setAttribute("close", "|");
        this.parameter[0].toMathML(e1, null);
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Abs(null);
    }
}

