/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Comparator;
import jscl.math.DoubleVariable;
import jscl.math.ExpressionVariable;
import jscl.math.IntegerVariable;
import jscl.math.MatrixVariable;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.VectorVariable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.ImplicitFunction;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.math.operator.Factorial;
import jscl.math.operator.Operator;

class VariableComparator
implements Comparator {
    public static final Comparator comparator = new VariableComparator();

    private VariableComparator() {
    }

    public int compare(Object o1, Object o2) {
        return VariableComparator.value((Variable)o1) - VariableComparator.value((Variable)o2);
    }

    static int value(Variable v) {
        int n;
        if (v instanceof TechnicalVariable) {
            n = 0;
        } else if (v instanceof IntegerVariable) {
            n = 1;
        } else if (v instanceof DoubleVariable) {
            n = 2;
        } else if (v instanceof Frac && ((Frac)v).integer()) {
            n = 3;
        } else if (v instanceof Sqrt && ((Sqrt)v).imaginary()) {
            n = 4;
        } else if (v instanceof Constant) {
            n = 5;
        } else if (v instanceof Root) {
            n = 6;
        } else if (v instanceof Algebraic) {
            n = 7;
        } else if (v instanceof ImplicitFunction) {
            n = 8;
        } else if (v instanceof Function) {
            n = 9;
        } else if (v instanceof Factorial) {
            n = 10;
        } else if (v instanceof Operator) {
            n = 11;
        } else if (v instanceof ExpressionVariable) {
            n = 12;
        } else if (v instanceof VectorVariable) {
            n = 13;
        } else if (v instanceof MatrixVariable) {
            n = 14;
        } else {
            throw new ArithmeticException();
        }
        return n;
    }
}

