/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.Variable;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;

class PolynomialWithSyzygy
extends UnivariatePolynomial {
    Polynomial[] syzygy = new Polynomial[2];

    PolynomialWithSyzygy(Variable variable) {
        super(variable);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        PolynomialWithSyzygy p2 = (PolynomialWithSyzygy)polynomial;
        PolynomialWithSyzygy p = (PolynomialWithSyzygy)super.subtract(p2);
        for (int i = 0; i < this.syzygy.length; ++i) {
            p.syzygy[i] = this.syzygy[i].subtract(p2.syzygy[i]);
        }
        return p;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        PolynomialWithSyzygy p = (PolynomialWithSyzygy)super.multiply(generic);
        for (int i = 0; i < this.syzygy.length; ++i) {
            p.syzygy[i] = this.syzygy[i].multiply(generic);
        }
        return p;
    }

    @Override
    public Polynomial multiply(Monomial monomial, Generic generic) {
        PolynomialWithSyzygy p = (PolynomialWithSyzygy)super.multiply(monomial, generic);
        for (int i = 0; i < this.syzygy.length; ++i) {
            p.syzygy[i] = this.syzygy[i].multiply(monomial).multiply(generic);
        }
        return p;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        PolynomialWithSyzygy p = (PolynomialWithSyzygy)super.divide(generic);
        for (int i = 0; i < this.syzygy.length; ++i) {
            p.syzygy[i] = this.syzygy[i].divide(generic);
        }
        return p;
    }

    @Override
    public Polynomial remainderUpToCoefficient(Polynomial polynomial) throws ArithmeticException {
        PolynomialWithSyzygy p = this;
        PolynomialWithSyzygy q = (PolynomialWithSyzygy)polynomial;
        if (p.signum() == 0) {
            return p;
        }
        int d = p.degree();
        int d2 = q.degree();
        for (int i = d - d2; i >= 0; --i) {
            Generic c1 = p.get(i + d2);
            Generic c2 = q.get(d2);
            Generic c = c1.gcd(c2);
            c1 = c1.divide(c);
            c2 = c2.divide(c);
            p = (PolynomialWithSyzygy)p.multiply(c2).subtract(q.multiply(this.monomial(Literal.valueOf(this.variable, i)), c1)).normalize();
        }
        return p;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        Polynomial p = this;
        Polynomial q = polynomial;
        while (q.signum() != 0) {
            Polynomial r = ((Polynomial)p).remainderUpToCoefficient(q);
            p = q;
            q = r;
        }
        return p;
    }

    @Override
    public Generic gcd() {
        Generic a = super.gcd();
        for (int i = 0; i < this.syzygy.length; ++i) {
            a = a.gcd(this.syzygy[i].gcd());
        }
        return a.signum() == this.signum() ? a : a.negate();
    }

    public PolynomialWithSyzygy valueof(Generic generic, int n) {
        PolynomialWithSyzygy p = (PolynomialWithSyzygy)this.newinstance();
        p.init(generic, n);
        return p;
    }

    public static Polynomial factory(Variable variable) {
        return new PolynomialWithSyzygy(variable);
    }

    void init(Generic generic, int n) {
        this.init(generic);
        for (int i = 0; i < this.syzygy.length; ++i) {
            this.syzygy[i] = Polynomial.factory(this.variable).valueof(JSCLInteger.valueOf(i == n ? 1L : 0L));
        }
    }

    @Override
    protected UnivariatePolynomial newinstance() {
        return new PolynomialWithSyzygy(this.variable);
    }
}

