/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.BaseStridedVector;
import mikera.vectorz.impl.Vector0;

public final class StridedVector
extends BaseStridedVector {
    private static final long serialVersionUID = 5807998427323932401L;

    private StridedVector(double[] data, int offset, int length, int stride) {
        super(length, data, offset, stride);
    }

    public static StridedVector wrap(double[] data, int offset, int length, int stride) {
        return new StridedVector(data, offset, length, stride);
    }

    @Override
    public void set(int i, double value) {
        this.checkIndex(i);
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int n = this.offset + i * this.stride;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void add(double[] data, int offset) {
        int stride = this.getStride();
        double[] tdata = this.getArray();
        int toffset = this.getArrayOffset();
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            int n = toffset + i * stride;
            tdata[n] = tdata[n] + data[offset + i];
        }
    }

    @Override
    public void add(AVector v) {
        v.checkLength(this.length());
        v.addToArray(this.getArray(), this.getArrayOffset(), this.getStride());
    }

    @Override
    public void add(int offset, AVector a, int srcOffset, int length) {
        int stride = this.getStride();
        a.subVector(srcOffset, length).addToArray(this.getArray(), this.getArrayOffset() + offset * stride, stride);
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data, this.offset, this.stride, this.length);
    }

    @Override
    public void set(AVector v) {
        int length = this.checkSameLength(v);
        v.copyTo(0, this.data, this.offset, length, this.stride);
    }

    @Override
    public void clamp(double min, double max) {
        for (int i = 0; i < this.length; ++i) {
            int ix = this.offset + i * this.stride;
            double v = this.data[ix];
            if (v < min) {
                this.data[ix] = min;
                continue;
            }
            if (!(v > max)) continue;
            this.data[ix] = max;
        }
    }

    @Override
    public void fill(double value) {
        int di = this.offset;
        for (int i = 0; i < this.length; ++i) {
            this.data[di] = value;
            di += this.stride;
        }
    }

    @Override
    public void multiply(double factor) {
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i * this.stride;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void setElements(double[] src, int srcOffset) {
        for (int i = 0; i < this.length; ++i) {
            this.data[this.offset + i * this.stride] = src[srcOffset + i];
        }
    }

    @Override
    public void setElements(int pos, double[] src, int srcOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.data[this.offset + i * this.stride] = src[srcOffset + i];
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public AVector subVector(int start, int length) {
        int len = this.checkRange(start, length);
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == len) {
            return this;
        }
        if (length == 1) {
            return ArraySubVector.wrap(this.data, this.offset + start * this.stride, 1);
        }
        return StridedVector.wrap(this.data, this.offset + start * this.stride, length, this.stride);
    }

    @Override
    public StridedVector exactClone() {
        double[] data = (double[])this.data.clone();
        return StridedVector.wrap(data, this.offset, this.length, this.stride);
    }
}

