/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.arrayz.INDArray;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.util.ErrorMessages;

public abstract class Op2 {
    public abstract double apply(double var1, double var3);

    public void applyTo(AVector a, AVector b) {
        if (a instanceof ADenseArrayVector) {
            this.applyTo((ADenseArrayVector)a, b);
        } else {
            a.applyOp(this, b);
        }
    }

    public void applyTo(AMatrix a, AMatrix b) {
        a.applyOp(this, b);
    }

    public void applyTo(AScalar a, AScalar b) {
        a.set(this.apply(a.get(), b.get()));
    }

    public void applyTo(ADenseArrayVector a, AVector b) {
        this.applyTo(a.getArray(), a.getArrayOffset(), a.length(), b);
    }

    public void applyTo(INDArray a, INDArray b) {
        if (a instanceof AVector) {
            this.applyTo((INDArray)((AVector)a), b.broadcastLike(a));
        } else if (a instanceof AMatrix) {
            this.applyTo((INDArray)((AMatrix)a), b.broadcastLike(a));
        } else if (a instanceof AScalar) {
            this.applyTo((INDArray)((AScalar)a), b.broadcastLike(a));
        } else {
            a.applyOp(this, b);
        }
    }

    public void applyTo(double[] data, int start, int length, AVector b) {
        b.checkLength(length);
        for (int i = 0; i < length; ++i) {
            double x = data[start + i];
            data[start + i] = this.apply(x, b.unsafeGet(i));
        }
    }

    public void applyTo(double[] data, int start, int length, double b) {
        for (int i = 0; i < length; ++i) {
            double x = data[start + i];
            data[start + i] = this.apply(x, b);
        }
    }

    public void applyTo(double[] data, AVector b) {
        this.applyTo(data, 0, data.length, b);
    }

    public void applyTo(double[] data, double b) {
        this.applyTo(data, 0, data.length, b);
    }

    public boolean isStochastic() {
        return false;
    }

    public double averageValue() {
        throw new UnsupportedOperationException();
    }

    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean validateOutput(double[] output) {
        double min = this.minValue();
        double max = this.maxValue();
        for (double d : output) {
            if (!(d < min) && !(d > max)) continue;
            return false;
        }
        return true;
    }

    public void constrainValues(double[] src, double[] dest, int offset, int length) {
        if (!this.isBounded()) {
            System.arraycopy(src, 0, dest, offset, length);
        }
        double min = this.minValue();
        double max = this.maxValue();
        for (int i = offset; i < offset + length; ++i) {
            double v = src[i];
            dest[i] = v > max ? max : (v < min ? min : v);
        }
    }

    public boolean isBounded() {
        return this.minValue() >= -1.7976931348623157E308 || this.maxValue() <= Double.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().toString();
    }

    public double reduce(double init, double[] data, int offset, int length) {
        double result = init;
        for (int i = 0; i < length; ++i) {
            result = this.apply(result, data[offset + i]);
        }
        return result;
    }

    public double reduce(double init, double[] data, int offset, int length, int stride) {
        double result = init;
        for (int i = 0; i < length; ++i) {
            result = this.apply(result, data[offset + i * stride]);
        }
        return result;
    }

    public double reduceZeros(double init, long length) {
        if (length == 0L) {
            return init;
        }
        if (length == 1L) {
            return this.apply(init, 0.0);
        }
        if (this.isStochastic()) {
            for (long i = 0L; i < length; ++i) {
                init = this.apply(init, 0.0);
            }
            return init;
        }
        double r1 = this.apply(init, 0.0);
        if (r1 == init) {
            return r1;
        }
        double r2 = this.apply(r1, 0.0);
        if (r2 == r1) {
            return r2;
        }
        for (long i = 2L; i < length; ++i) {
            r2 = this.apply(r2, 0.0);
        }
        return r2;
    }

    public double reduceZeros(long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Can't reduce over zero elements without initial value");
        }
        return this.reduceZeros(0.0, length - 1L);
    }

    public Op2 getDerivative(int i) {
        throw new UnsupportedOperationException(ErrorMessages.noDerivative(this));
    }
}

