/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ARectangularMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.SubMatrixViewVector;

public class SubMatrixView
extends ARectangularMatrix {
    private static final long serialVersionUID = -4687657697203057278L;
    private AMatrix source;
    private int rowStart;
    private int colStart;

    public SubMatrixView(AMatrix source, int rowStart, int colStart, int rows, int cols) {
        super(rows, cols);
        source.checkRow(rowStart);
        source.checkRow(rowStart + rows - 1);
        source.checkColumn(colStart);
        source.checkColumn(colStart + cols - 1);
        this.source = source;
        this.rowStart = rowStart;
        this.colStart = colStart;
    }

    @Override
    public double get(int i, int j) {
        this.checkIndex(i, j);
        return this.unsafeGet(i, j);
    }

    @Override
    public void set(int i, int j, double value) {
        this.checkIndex(i, j);
        this.unsafeSet(i, j, value);
    }

    @Override
    public double unsafeGet(int i, int j) {
        return this.source.unsafeGet(this.rowStart + i, this.colStart + j);
    }

    @Override
    public void unsafeSet(int i, int j, double value) {
        this.source.unsafeSet(this.rowStart + i, this.colStart + j, value);
    }

    @Override
    public boolean isFullyMutable() {
        return this.source.isFullyMutable();
    }

    @Override
    public boolean isMutable() {
        return this.source.isMutable();
    }

    @Override
    public AMatrix exactClone() {
        return new SubMatrixView(this.source.exactClone(), this.rowStart, this.colStart, this.rows, this.cols);
    }

    @Override
    public AVector asVector() {
        return new SubMatrixViewVector(this.source, this.rowStart, this.colStart, this.rows, this.cols);
    }

    @Override
    public AVector getRow(int i) {
        this.checkRow(i);
        return this.source.getRow(this.rowStart + i).subVector(this.colStart, this.cols);
    }

    @Override
    public AVector getColumn(int j) {
        this.checkColumn(j);
        return this.source.getColumn(this.colStart + j).subVector(this.rowStart, this.rows);
    }

    @Override
    public AVector getRowView(int i) {
        this.checkRow(i);
        return this.source.getRowView(this.rowStart + i).subVector(this.colStart, this.cols);
    }

    @Override
    public AVector getColumnView(int j) {
        this.checkColumn(j);
        return this.source.getColumnView(this.colStart + j).subVector(this.rowStart, this.rows);
    }

    @Override
    public AVector getRowClone(int i) {
        this.checkRow(i);
        return this.source.getRow(this.rowStart + i).subVector(this.colStart, this.cols).clone();
    }

    @Override
    public AVector getColumnClone(int j) {
        this.checkColumn(j);
        return this.source.getColumn(this.colStart + j).subVector(this.rowStart, this.rows).clone();
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        this.source.getRow(this.rowStart + row).copyTo(this.colStart, dest, destOffset, this.cols);
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        this.source.getColumn(this.colStart + col).copyTo(this.rowStart, dest, destOffset, this.rows);
    }
}

