/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.ADenseArrayMatrix;
import mikera.matrixx.impl.AStridedMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedMatrixViewVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class StridedRowMatrix
extends AStridedMatrix {
    private static final long serialVersionUID = -7928115802247422177L;
    private final int offset;
    private final int rowStride;

    private StridedRowMatrix(double[] data, int rowCount, int columnCount, int offset, int rowStride) {
        super(data, rowCount, columnCount);
        this.rowStride = rowStride;
        this.offset = offset;
    }

    @Override
    public final double get(int i, int j) {
        this.checkIndex(i, j);
        return this.data[this.index(i, j)];
    }

    @Override
    public final void set(int i, int j, double value) {
        this.checkIndex(i, j);
        this.data[this.index((int)i, (int)j)] = value;
    }

    @Override
    public final double unsafeGet(int i, int j) {
        return this.data[this.index(i, j)];
    }

    @Override
    public final void unsafeSet(int i, int j, double value) {
        this.data[this.index((int)i, (int)j)] = value;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public AStridedVector getRow(int i) {
        this.checkRow(i);
        return ArraySubVector.wrap(this.data, this.offset + i * this.rowStride, this.cols);
    }

    @Override
    public AStridedVector getColumn(int i) {
        return Vectorz.wrapStrided(this.data, this.offset + i, this.rows, this.rowStride);
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        System.arraycopy(this.data, this.offset + row * this.rowStride, dest, destOffset, this.cols);
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        int colOffset = this.offset + col;
        for (int i = 0; i < this.rows; ++i) {
            dest[destOffset + i] = this.data[colOffset + i * this.rowStride];
        }
    }

    @Override
    public boolean isPackedArray() {
        return this.offset == 0 && this.rowStride == this.cols && this.data.length == this.rows * this.cols;
    }

    @Override
    public AStridedMatrix subMatrix(int rowStart, int rowCount, int colStart, int colCount) {
        if (rowStart < 0 || rowStart >= this.rows || colStart < 0 || colStart >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart, colStart));
        }
        if (rowStart + rowCount > this.rows || colStart + colCount > this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart + rowCount, colStart + colCount));
        }
        return new StridedRowMatrix(this.data, rowCount, colCount, this.offset + rowStart * this.rowStride + colStart, this.rowStride);
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        int o = this.offset;
        for (int row = 0; row < rc; ++row) {
            int ro = o + row * this.rowStride();
            for (int col = 0; col < cc; ++col) {
                int index = ro + col;
                double v = this.data[index];
                this.data[index] = op.apply(v);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int row = 0; row < rc; ++row) {
            this.copyRowTo(row, dest, destOffset + row * cc);
        }
    }

    @Override
    public double rowDotProduct(int row, AVector v) {
        return v.dotProduct(this.data, this.index(row, 0));
    }

    @Override
    public void setRow(int row, AVector v) {
        v.getElements(this.data, this.index(row, 0));
    }

    @Override
    public AStridedMatrix getTranspose() {
        return Matrixx.wrapStrided(this.data, this.cols, this.rows, this.offset, 1, this.rowStride);
    }

    @Override
    public AStridedMatrix getTransposeView() {
        return Matrixx.wrapStrided(this.data, this.cols, this.rows, this.offset, 1, this.rowStride);
    }

    @Override
    public AVector asVector() {
        if (this.isPackedArray()) {
            return Vector.wrap(this.data);
        }
        if (this.cols == 1) {
            return Vectorz.wrapStrided(this.data, this.offset, this.rows, this.rowStride);
        }
        if (this.rows == 1) {
            return Vectorz.wrapStrided(this.data, this.offset, this.cols, 1);
        }
        return new StridedMatrixViewVector(this);
    }

    @Override
    public AMatrix exactClone() {
        return new StridedRowMatrix((double[])this.data.clone(), this.rows, this.cols, this.offset, this.rowStride);
    }

    public static StridedRowMatrix wrap(AStridedMatrix m) {
        if (m.columnStride() != 1) {
            throw new IllegalArgumentException("StridedRowMatrix creation requires a column stride of 1");
        }
        return new StridedRowMatrix(m.getArray(), m.rowCount(), m.columnCount(), m.getArrayOffset(), m.rowStride());
    }

    public static StridedRowMatrix wrap(double[] data, int rows, int columns, int offset, int rowStride) {
        return new StridedRowMatrix(data, rows, columns, offset, rowStride);
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.equals(this.exactClone())) {
            throw new VectorzException("Thing not equal to itself");
        }
        if (this.offset < 0) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
        if (this.index(this.rows - 1, this.cols - 1) >= this.data.length) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
    }

    @Override
    public boolean equals(AMatrix a) {
        if (a == this) {
            return true;
        }
        if (!this.isSameShape(a)) {
            return false;
        }
        if (a instanceof ADenseArrayMatrix) {
            ADenseArrayMatrix da = (ADenseArrayMatrix)a;
            return this.equalsArray(da.getArray(), da.getArrayOffset());
        }
        for (int i = 0; i < this.rows; ++i) {
            if (a.getRow(i).equalsArray(this.data, this.offset + i * this.rowStride)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        for (int i = 0; i < this.rows; ++i) {
            int rowOffset = this.offset + i * this.rowStride;
            for (int j = 0; j < this.cols; ++j) {
                if (this.data[rowOffset + j] == data[offset++]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public int rowStride() {
        return this.rowStride;
    }

    @Override
    public int columnStride() {
        return 1;
    }

    @Override
    protected int index(int i, int j) {
        return this.offset + this.rowStride * i + j;
    }
}

