/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.ISparse;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ABandedMatrix;
import mikera.matrixx.impl.BandedMatrix;
import mikera.matrixx.impl.ZeroMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public abstract class ASingleBandMatrix
extends ABandedMatrix
implements ISparse {
    private static final long serialVersionUID = -213068993524224396L;

    public abstract int nonZeroBand();

    public abstract AVector getNonZeroBand();

    @Override
    public boolean isSymmetric() {
        if (this.rowCount() != this.columnCount()) {
            return false;
        }
        return this.nonZeroBand() == 0 || this.getNonZeroBand().isZero();
    }

    @Override
    public AMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        int nzb = this.nonZeroBand();
        int minBand = colStart - rowStart - rows + 1;
        int maxBand = colStart - rowStart + cols - 1;
        if (rows == 0 || cols == 0 || nzb < minBand || nzb > maxBand) {
            return ZeroMatrix.create(rows, cols);
        }
        int destBand = nzb + rowStart - colStart;
        int destBandLength = BandedMatrix.bandLength(rows, cols, destBand);
        int destBandStart = Math.max(rowStart - this.bandStartRow(nzb), colStart - this.bandStartColumn(nzb));
        AVector b = this.getNonZeroBand().subVector(destBandStart, destBandLength);
        return BandedMatrix.wrap(rows, cols, destBand, destBand, b);
    }

    @Override
    public boolean isIdentity() {
        return this.isSquare() && this.nonZeroBand() == 0 && this.getNonZeroBand().elementsEqual(1.0);
    }

    @Override
    public boolean isZero() {
        return this.getNonZeroBand().isZero();
    }

    @Override
    public final boolean isSparse() {
        return true;
    }

    @Override
    public long nonZeroCount() {
        return this.getNonZeroBand().nonZeroCount();
    }

    @Override
    public AVector getBand(int band) {
        if (band == this.nonZeroBand()) {
            return this.getNonZeroBand();
        }
        return Vectorz.createZeroVector(this.bandLength(band));
    }

    @Override
    public boolean hasUncountable() {
        return this.getNonZeroBand().hasUncountable();
    }

    @Override
    public int rank() {
        return (int)this.getNonZeroBand().nonZeroCount();
    }

    @Override
    public double elementPowSum(double p) {
        return this.getNonZeroBand().elementPowSum(p);
    }

    @Override
    public double elementAbsPowSum(double p) {
        return this.getNonZeroBand().elementAbsPowSum(p);
    }
}

