/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.INDArray;
import mikera.matrixx.AMatrix;
import mikera.vectorz.util.ErrorMessages;

public abstract class ARectangularMatrix
extends AMatrix {
    private static final long serialVersionUID = 6429003789294676974L;
    protected final int rows;
    protected final int cols;

    protected ARectangularMatrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public final int rowCount() {
        return this.rows;
    }

    @Override
    public final int columnCount() {
        return this.cols;
    }

    @Override
    public final boolean isSquare() {
        return this.rows == this.cols;
    }

    @Override
    public final int[] getShape() {
        return new int[]{this.rows, this.cols};
    }

    @Override
    public final int[] getShapeClone() {
        return new int[]{this.rows, this.cols};
    }

    @Override
    public void set(int i, int j, double value) {
        this.checkIndex(i, j);
        this.unsafeSet(i, j, value);
    }

    @Override
    public final int bandLength(int band) {
        return ARectangularMatrix.bandLength(this.rows, this.cols, band);
    }

    @Override
    public final int getShape(int dim) {
        if (dim == 0) {
            return this.rows;
        }
        if (dim == 1) {
            return this.cols;
        }
        throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dim));
    }

    @Override
    public final boolean isSameShape(INDArray m) {
        return m.dimensionality() == 2 && this.rows == m.getShape(0) && this.cols == m.getShape(1);
    }

    @Override
    public int checkSquare() {
        int rc = this.rows;
        if (rc != this.cols) {
            throw new UnsupportedOperationException(ErrorMessages.nonSquareMatrix(this));
        }
        return rc;
    }

    @Override
    public final int checkColumn(int column) {
        if (column < 0 || column >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidSlice(this, 1, column));
        }
        return this.cols;
    }

    @Override
    public final int checkRow(int row) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidSlice(this, 0, row));
        }
        return this.rows;
    }

    @Override
    protected final void checkSameShape(AMatrix m) {
        if (this.rows != m.rowCount() || this.cols != m.columnCount()) {
            throw new IndexOutOfBoundsException(ErrorMessages.mismatch(this, m));
        }
    }

    @Override
    protected final void checkSameShape(ARectangularMatrix m) {
        if (this.rows != m.rows || this.cols != m.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.mismatch(this, m));
        }
    }

    @Override
    protected final int checkRowCount(int expected) {
        int rc = this.rowCount();
        if (rc != expected) {
            throw new IllegalArgumentException("Unexpected row count: " + rc + " expected: " + expected);
        }
        return rc;
    }

    @Override
    protected final int checkColumnCount(int expected) {
        int cc = this.columnCount();
        if (cc != expected) {
            throw new IllegalArgumentException("Unexpected column count: " + cc + " expected: " + expected);
        }
        return cc;
    }

    @Override
    protected final void checkIndex(int i, int j) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex((INDArray)this, i, j));
        }
    }

    @Override
    public final boolean isSameShape(AMatrix m) {
        return this.rows == m.rowCount() && this.cols == m.columnCount();
    }

    public final boolean isSameShape(ARectangularMatrix m) {
        return this.rows == m.rows && this.cols == m.cols;
    }

    @Override
    public final long elementCount() {
        return (long)this.rows * (long)this.cols;
    }

    @Override
    public final double getElement(long i) {
        if (i < 0L || i >= (long)this.rows * (long)this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidElementIndex(this, i));
        }
        return this.unsafeGet((int)(i / (long)this.cols), (int)(i % (long)this.cols));
    }
}

