/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.validation.AdjustedRandIndex;
import smile.validation.RandIndex;
import smile.vq.GrowingNeuralGas;

public class GrowingNeuralGasTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            GrowingNeuralGas gng = new GrowingNeuralGas(x[0].length);
            for (int i = 0; i < 10; ++i) {
                int[] index = Math.permutate(x.length);
                for (int j = 0; j < x.length; ++j) {
                    gng.update(x[index[j]]);
                }
            }
            gng.partition(10);
            AdjustedRandIndex ari = new AdjustedRandIndex();
            RandIndex rand = new RandIndex();
            int[] p = new int[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = gng.predict(x[i]);
            }
            double r = rand.measure(y, p);
            double r2 = ari.measure(y, p);
            System.out.format("Training rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
            Assert.assertTrue(r > 0.85);
            Assert.assertTrue(r2 > 0.4);
            p = new int[testx.length];
            for (int i = 0; i < testx.length; ++i) {
                p[i] = gng.predict(testx[i]);
            }
            r = rand.measure(testy, p);
            r2 = ari.measure(testy, p);
            System.out.format("Testing rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
            Assert.assertTrue(r > 0.85);
            Assert.assertTrue(r2 > 0.4);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

