/*
 * Decompiled with CFR 0.152.
 */
package smile.taxonomy;

import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.taxonomy.Concept;
import smile.taxonomy.TaxonomicDistance;
import smile.taxonomy.Taxonomy;

public class TaxonomyTest {
    Taxonomy instance = new Taxonomy("MyTaxo");
    Concept a;
    Concept b;
    Concept c;
    Concept d;
    Concept e;
    Concept f;
    Concept ad;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        String[] concepts = new String[]{"A", "B", "C", "D", "E", "F"};
        Concept root = this.instance.getRoot();
        this.ad = root.addChild("");
        this.e = root.addChild("E");
        this.d = this.ad.addChild("D");
        this.a = this.ad.addChild("A");
        this.b = this.a.addChild("B");
        this.c = this.a.addChild("C");
        this.f = this.c.addChild("F");
        System.out.println("Taxonomy created:\n");
        System.out.println("       --|---");
        System.out.println("       |    |");
        System.out.println("    ---|--  |");
        System.out.println("    |    |  |");
        System.out.println("  --A--  |  |");
        System.out.println("  |   |  |  |");
        System.out.println("  B   C  D  E");
        System.out.println("      |      ");
        System.out.println("      F      ");
        System.out.println();
        System.out.println();
        for (int i = 0; i < concepts.length; ++i) {
            System.out.println(this.instance.getConcept(concepts[i]));
        }
        System.out.println();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLowestCommonAncestor() {
        System.out.println("lowestCommonAncestor");
        Concept result = this.instance.lowestCommonAncestor("A", "B");
        Assert.assertEquals(this.a, result);
        result = this.instance.lowestCommonAncestor("E", "B");
        Assert.assertEquals(this.instance.getRoot(), result);
    }

    @Test
    public void testGetPathToRoot() {
        System.out.println("getPathToRoot");
        LinkedList<Concept> expResult = new LinkedList<Concept>();
        expResult.addFirst(this.instance.getRoot());
        expResult.addFirst(this.ad);
        expResult.addFirst(this.a);
        expResult.addFirst(this.c);
        expResult.addFirst(this.f);
        List<Concept> result = this.f.getPathToRoot();
        Assert.assertEquals(expResult, result);
    }

    @Test
    public void testGetPathFromRoot() {
        System.out.println("getPathToRoot");
        LinkedList<Concept> expResult = new LinkedList<Concept>();
        expResult.add(this.instance.getRoot());
        expResult.add(this.ad);
        expResult.add(this.a);
        expResult.add(this.c);
        expResult.add(this.f);
        List<Concept> result = this.f.getPathFromRoot();
        Assert.assertEquals(expResult, result);
    }

    @Test
    public void testDistance() {
        System.out.println("distance");
        TaxonomicDistance td = new TaxonomicDistance(this.instance);
        Assert.assertEquals(2.0, td.d("A", "F"), 1.0E-9);
        Assert.assertEquals(5.0, td.d("E", "F"), 1.0E-9);
    }
}

