/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import smile.swing.AlphaIcon;
import smile.swing.table.DefaultTableHeaderCellRenderer;

public class MultiColumnSortTableHeaderCellRenderer
extends DefaultTableHeaderCellRenderer {
    private float alpha;

    public MultiColumnSortTableHeaderCellRenderer() {
        this(0.5f);
    }

    public MultiColumnSortTableHeaderCellRenderer(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public Icon getIcon(JTable table, int column) {
        float computedAlpha = 1.0f;
        for (RowSorter.SortKey sortKey : table.getRowSorter().getSortKeys()) {
            if (table.convertColumnIndexToView(sortKey.getColumn()) == column) {
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        return new AlphaIcon(UIManager.getIcon("Table.ascendingSortIcon"), computedAlpha);
                    }
                    case DESCENDING: {
                        return new AlphaIcon(UIManager.getIcon("Table.descendingSortIcon"), computedAlpha);
                    }
                }
            }
            computedAlpha *= this.alpha;
        }
        return null;
    }
}

