/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import smile.data.Attribute;
import smile.data.NumericAttribute;
import smile.math.Math;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;
import smile.regression.RegressionTree;
import smile.util.MulticoreExecutor;
import smile.util.SmileUtils;
import smile.validation.RMSE;
import smile.validation.RegressionMeasure;

public class RandomForest
implements Regression<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<RegressionTree> trees;
    private double error;
    private double[] importance;

    public RandomForest(double[][] x, double[] y, int ntrees) {
        this(null, x, y, ntrees);
    }

    public RandomForest(double[][] x, double[] y, int ntrees, int maxNodes, int nodeSize, int mtry) {
        this(null, x, y, ntrees, maxNodes, nodeSize, mtry);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int ntrees) {
        this(attributes, x, y, ntrees, 100);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int ntrees, int maxNodes) {
        this(attributes, x, y, ntrees, maxNodes, 5);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int ntrees, int maxNodes, int nodeSize) {
        this(attributes, x, y, ntrees, maxNodes, nodeSize, x[0].length / 3);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int ntrees, int maxNodes, int nodeSize, int mtry) {
        this(attributes, x, y, ntrees, maxNodes, nodeSize, mtry, 1.0);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int ntrees, int maxNodes, int nodeSize, int mtry, double subsample) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (ntrees < 1) {
            throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
        }
        if (mtry < 1 || mtry > x[0].length) {
            throw new IllegalArgumentException("Invalid number of variables to split on at a node of the tree: " + mtry);
        }
        if (nodeSize < 2) {
            throw new IllegalArgumentException("Invalid minimum size of leaves: " + nodeSize);
        }
        if (maxNodes < 2) {
            throw new IllegalArgumentException("Invalid maximum number of leaves: " + maxNodes);
        }
        if (subsample <= 0.0 || subsample > 1.0) {
            throw new IllegalArgumentException("Invalid sampling rate: " + subsample);
        }
        if (attributes == null) {
            int p = x[0].length;
            attributes = new Attribute[p];
            for (int i2 = 0; i2 < p; ++i2) {
                attributes[i2] = new NumericAttribute("V" + (i2 + 1));
            }
        }
        int n = x.length;
        double[] prediction = new double[n];
        int[] oob = new int[n];
        int[][] order = SmileUtils.sort(attributes, x);
        ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>();
        for (int i3 = 0; i3 < ntrees; ++i3) {
            tasks.add(new TrainingTask(attributes, x, y, maxNodes, nodeSize, mtry, subsample, order, prediction, oob));
        }
        try {
            this.trees = MulticoreExecutor.run(tasks);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.trees = new ArrayList<RegressionTree>(ntrees);
            for (i = 0; i < ntrees; ++i) {
                this.trees.add(((TrainingTask)tasks.get(i)).call());
            }
        }
        int m = 0;
        for (i = 0; i < n; ++i) {
            if (oob[i] <= 0) continue;
            ++m;
            double pred = prediction[i] / (double)oob[i];
            this.error += Math.sqr(pred - y[i]);
        }
        if (m > 0) {
            this.error = Math.sqrt(this.error / (double)m);
        }
        this.importance = new double[attributes.length];
        for (RegressionTree tree : this.trees) {
            double[] imp = tree.importance();
            for (int i4 = 0; i4 < imp.length; ++i4) {
                int n2 = i4;
                this.importance[n2] = this.importance[n2] + imp[i4];
            }
        }
    }

    public double error() {
        return this.error;
    }

    public double[] importance() {
        return this.importance;
    }

    public int size() {
        return this.trees.size();
    }

    public void trim(int ntrees) {
        if (ntrees > this.trees.size()) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (ntrees <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + ntrees);
        }
        ArrayList<RegressionTree> model = new ArrayList<RegressionTree>(ntrees);
        for (int i = 0; i < ntrees; ++i) {
            model.add(this.trees.get(i));
        }
        this.trees = model;
    }

    @Override
    public double predict(double[] x) {
        double y = 0.0;
        for (RegressionTree tree : this.trees) {
            y += tree.predict(x);
        }
        return y / (double)this.trees.size();
    }

    public double[] test(double[][] x, double[] y) {
        int T = this.trees.size();
        double[] rmse = new double[T];
        int n = x.length;
        double[] sum = new double[n];
        double[] prediction = new double[n];
        RMSE measure = new RMSE();
        int i = 0;
        int nt = 1;
        while (i < T) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                sum[n2] = sum[n2] + this.trees.get(i).predict(x[j]);
                prediction[j] = sum[j] / (double)nt;
            }
            rmse[i] = measure.measure(y, prediction);
            ++i;
            ++nt;
        }
        return rmse;
    }

    public double[][] test(double[][] x, double[] y, RegressionMeasure[] measures) {
        int T = this.trees.size();
        int m = measures.length;
        double[][] results = new double[T][m];
        int n = x.length;
        double[] sum = new double[n];
        double[] prediction = new double[n];
        int i = 0;
        int nt = 1;
        while (i < T) {
            int j;
            for (j = 0; j < n; ++j) {
                int n2 = j;
                sum[n2] = sum[n2] + this.trees.get(i).predict(x[j]);
                prediction[j] = sum[j] / (double)nt;
            }
            for (j = 0; j < m; ++j) {
                results[i][j] = measures[j].measure(y, prediction);
            }
            ++i;
            ++nt;
        }
        return results;
    }

    public RegressionTree[] getTrees() {
        return this.trees.toArray(new RegressionTree[this.trees.size()]);
    }

    static class TrainingTask
    implements Callable<RegressionTree> {
        Attribute[] attributes;
        double[][] x;
        double[] y;
        int[][] order;
        int mtry;
        int nodeSize = 5;
        int maxNodes = 100;
        double subsample = 1.0;
        double[] prediction;
        int[] oob;

        TrainingTask(Attribute[] attributes, double[][] x, double[] y, int maxNodes, int nodeSize, int mtry, double subsample, int[][] order, double[] prediction, int[] oob) {
            this.attributes = attributes;
            this.x = x;
            this.y = y;
            this.order = order;
            this.mtry = mtry;
            this.nodeSize = nodeSize;
            this.maxNodes = maxNodes;
            this.subsample = subsample;
            this.prediction = prediction;
            this.oob = oob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegressionTree call() {
            int i;
            int n = this.x.length;
            int[] samples = new int[n];
            if (this.subsample == 1.0) {
                for (int i2 = 0; i2 < n; ++i2) {
                    int xi;
                    int n2 = xi = Math.randomInt(n);
                    samples[n2] = samples[n2] + 1;
                }
            } else {
                int[] perm = new int[n];
                for (i = 0; i < n; ++i) {
                    perm[i] = i;
                }
                Math.permutate(perm);
                int m = (int)Math.round((double)n * this.subsample);
                for (int i3 = 0; i3 < m; ++i3) {
                    int n3 = perm[i3];
                    samples[n3] = samples[n3] + 1;
                }
            }
            RegressionTree tree = new RegressionTree(this.attributes, this.x, this.y, this.maxNodes, this.nodeSize, this.mtry, this.order, samples, null);
            for (i = 0; i < n; ++i) {
                if (samples[i] != 0) continue;
                double pred = tree.predict(this.x[i]);
                double[] dArray = this.x[i];
                synchronized (dArray) {
                    int n4 = i;
                    this.prediction[n4] = this.prediction[n4] + pred;
                    int n5 = i;
                    this.oob[n5] = this.oob[n5] + 1;
                    continue;
                }
            }
            return tree;
        }
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private int ntrees = 500;
        private int mtry = -1;
        private int nodeSize = 5;
        private int maxNodes = 100;
        private double subsample = 1.0;

        public Trainer(int ntrees) {
            if (ntrees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
            }
            this.ntrees = ntrees;
        }

        public Trainer(Attribute[] attributes, int ntrees) {
            super(attributes);
            if (ntrees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
            }
            this.ntrees = ntrees;
        }

        public Trainer setNumTrees(int ntrees) {
            if (ntrees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
            }
            this.ntrees = ntrees;
            return this;
        }

        public Trainer setNumRandomFeatures(int mtry) {
            if (mtry < 1) {
                throw new IllegalArgumentException("Invalid number of random selected features for splitting: " + mtry);
            }
            this.mtry = mtry;
            return this;
        }

        public Trainer setMaxNodes(int maxNodes) {
            if (maxNodes < 2) {
                throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + maxNodes);
            }
            this.maxNodes = maxNodes;
            return this;
        }

        public Trainer setNodeSize(int nodeSize) {
            if (nodeSize < 1) {
                throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + nodeSize);
            }
            this.nodeSize = nodeSize;
            return this;
        }

        public Trainer setSamplingRates(double subsample) {
            if (subsample <= 0.0 || subsample > 1.0) {
                throw new IllegalArgumentException("Invalid sampling rate: " + subsample);
            }
            this.subsample = subsample;
            return this;
        }

        public RandomForest train(double[][] x, double[] y) {
            return new RandomForest(this.attributes, x, y, this.ntrees, this.maxNodes, this.nodeSize, this.mtry, this.subsample);
        }
    }
}

