/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class Grid
extends Plot {
    private double[][][] data;
    private boolean drawNodes = false;

    public Grid(double[][][] data) {
        this(data, false);
    }

    public Grid(double[][][] data, boolean drawNodes) {
        this(data, drawNodes, Color.BLACK);
    }

    public Grid(double[][][] data, boolean drawNodes, Color color) {
        super(color);
        this.data = data;
        this.drawNodes = drawNodes;
    }

    public boolean setDrawNodes() {
        return this.drawNodes;
    }

    public void setDrawNodes(boolean drawNodes) {
        this.drawNodes = drawNodes;
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        Color c = g.getColor();
        g.setColor(this.getColor());
        for (i = 0; i < this.data.length; ++i) {
            for (j = 0; j < this.data[i].length - 1; ++j) {
                if (this.drawNodes) {
                    g.drawPoint('o', this.data[i][j]);
                }
                g.drawLine(this.data[i][j], this.data[i][j + 1]);
            }
            if (!this.drawNodes) continue;
            g.drawPoint('o', this.data[i][this.data[i].length - 1]);
        }
        for (i = 0; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                g.drawLine(this.data[i][j], this.data[i + 1][j]);
            }
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[][][] data) {
        return Grid.plot(null, data);
    }

    public static PlotCanvas plot(String id, double[][][] data) {
        double[] lowerBound = new double[]{data[0][0][0], data[0][0][1]};
        double[] upperBound = new double[]{data[0][0][0], data[0][0][1]};
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j][0] < lowerBound[0]) {
                    lowerBound[0] = data[i][j][0];
                }
                if (data[i][j][0] > upperBound[0]) {
                    upperBound[0] = data[i][j][0];
                }
                if (data[i][j][1] < lowerBound[1]) {
                    lowerBound[1] = data[i][j][1];
                }
                if (!(data[i][j][1] > upperBound[1])) continue;
                upperBound[1] = data[i][j][1];
            }
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Grid grid = new Grid(data);
        if (id != null) {
            grid.setID(id);
        }
        canvas.add(grid);
        return canvas;
    }
}

