/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.LinearSearch;
import smile.neighbor.MPLSH;
import smile.neighbor.Neighbor;

public class MPLSHSpeedTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUSPS() {
        int i;
        System.out.println("USPS");
        double[][] x = null;
        double[][] testx = null;
        long start = System.currentTimeMillis();
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            x = (double[][])train.toArray((E[])new double[train.size()][]);
            testx = (double[][])test.toArray((E[])new double[test.size()][]);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading USPS: %.2fs%n", time);
        start = System.currentTimeMillis();
        MPLSH<Object> lsh = new MPLSH<Object>(256, 100, 3, 4.0);
        for (double[] xi : x) {
            lsh.put(xi, xi);
        }
        double[][] train = new double[500][];
        int[] index = Math.permutate(x.length);
        for (int i2 = 0; i2 < train.length; ++i2) {
            train[i2] = x[index[i2]];
        }
        LinearSearch<double[]> naive = new LinearSearch<double[]>((T[])x, new EuclideanDistance());
        lsh.learn(naive, train, 8.0);
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Building LSH: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 0; i < testx.length; ++i) {
            lsh.nearest(testx[i]);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 0; i < testx.length; ++i) {
            lsh.knn(testx[i], 10);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("10-NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        ArrayList n = new ArrayList();
        for (int i3 = 0; i3 < testx.length; ++i3) {
            lsh.range(testx[i3], 8.0, (List<Neighbor<double[], Object>>)n);
            n.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Range: %.2fs%n", time);
    }
}

