/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.parser.IOUtils;
import smile.math.distance.EditDistance;
import smile.neighbor.BKTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

public class BKTreeTest {
    List<String> words = new ArrayList<String>();
    BKTree<String> bktree;
    LinearSearch<String> naive;

    public BKTreeTest() {
        try {
            BufferedReader input = IOUtils.getTestDataReader("neighbor/index.noun");
            String line = input.readLine();
            while (line != null) {
                if (!line.startsWith(" ")) {
                    String[] w = line.split("\\s");
                    this.words.add(w[0].replace('_', ' '));
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String[] data = this.words.toArray(new String[1]);
        this.bktree = new BKTree<String>(new EditDistance(50, true));
        this.bktree.add((String)data);
        this.naive = new LinearSearch<String>(data, new EditDistance(50, true));
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRange() {
        System.out.println("range");
        ArrayList n1 = new ArrayList();
        ArrayList n2 = new ArrayList();
        for (int i = 1000; i < 1100; ++i) {
            int j;
            this.bktree.range(this.words.get(i), 1, (List<Neighbor<String, String>>)n1);
            this.naive.range(this.words.get(i), 1.0, n2);
            Assert.assertEquals(n1.size(), n2.size());
            Object[] s1 = new String[n1.size()];
            Object[] s2 = new String[n2.size()];
            for (j = 0; j < s1.length; ++j) {
                s1[j] = (String)((Neighbor)n1.get((int)j)).value;
                s2[j] = (String)((Neighbor)n2.get((int)j)).value;
            }
            Arrays.sort(s1);
            Arrays.sort(s2);
            for (j = 0; j < s1.length; ++j) {
                Assert.assertEquals(s1[j], s2[j]);
            }
            n1.clear();
            n2.clear();
        }
    }
}

