/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.kernel.MercerKernel;

public class SparseLaplacianKernel
implements MercerKernel<SparseArray>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double gamma;

    public SparseLaplacianKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 1.0 / sigma;
    }

    public String toString() {
        return String.format("Sparse Laplacian kernel (\u02e0 = %.4f)", 1.0 / this.gamma);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        return Math.exp(-this.gamma * Math.distance(x, y));
    }
}

