/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation;
import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.rbf.GaussianRadialBasis;
import smile.math.rbf.RadialBasisFunction;

public class RBFInterpolation1D
implements Interpolation {
    private double[] x;
    private double[] w;
    private RadialBasisFunction rbf;
    private boolean normalized;

    public RBFInterpolation1D(double[] x, double[] y, RadialBasisFunction rbf) {
        this(x, y, rbf, false);
    }

    public RBFInterpolation1D(double[] x, double[] y, RadialBasisFunction rbf, boolean normalized) {
        this.x = x;
        this.rbf = rbf;
        this.normalized = normalized;
        int n = x.length;
        DenseMatrix G = Matrix.zeros(n, n);
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j <= i; ++j) {
                double r = rbf.f(Math.abs(x[i] - x[j]));
                G.set(i, j, r);
                G.set(j, i, r);
                sum += 2.0 * r;
            }
            rhs[i] = normalized ? sum * y[i] : y[i];
        }
        if (rbf instanceof GaussianRadialBasis) {
            Cholesky cholesky = G.cholesky();
            cholesky.solve(rhs);
            this.w = rhs;
        } else {
            LU lu = G.lu(true);
            lu.solve(rhs);
            this.w = rhs;
        }
    }

    @Override
    public double interpolate(double x) {
        double sum = 0.0;
        double sumw = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            double f = this.rbf.f(Math.abs(x - this.x[i]));
            sumw += this.w[i] * f;
            sum += f;
        }
        return this.normalized ? sumw / sum : sumw;
    }
}

