/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.variogram.PowerVariogram;
import smile.interpolation.variogram.Variogram;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;

public class KrigingInterpolation {
    private double[][] x;
    private Variogram variogram;
    private double[] yvi;
    private double[] vstar;

    public KrigingInterpolation(double[][] x, double[] y) {
        this(x, y, new PowerVariogram(x, y), null);
    }

    public KrigingInterpolation(double[][] x, double[] y, Variogram variogram, double[] error) {
        int i;
        this.x = x;
        this.variogram = variogram;
        int n = x.length;
        this.yvi = new double[n + 1];
        this.vstar = new double[n + 1];
        DenseMatrix v = Matrix.zeros(n + 1, n + 1);
        for (i = 0; i < n; ++i) {
            this.yvi[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var = variogram.f(this.rdist(x[i], x[j]));
                v.set(i, j, var);
                v.set(j, i, var);
            }
            v.set(n, i, 1.0);
            v.set(i, n, 1.0);
        }
        this.yvi[n] = 0.0;
        v.set(n, n, 0.0);
        if (error != null) {
            for (i = 0; i < n; ++i) {
                v.sub(i, i, error[i] * error[i]);
            }
        }
        LU lu = v.lu(true);
        lu.solve(this.yvi);
    }

    public double interpolate(double ... x) {
        if (x.length != this.x[0].length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.x[0].length));
        }
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.vstar[i] = this.variogram.f(this.rdist(x, this.x[i]));
        }
        this.vstar[n] = 1.0;
        double y = 0.0;
        for (int i = 0; i <= n; ++i) {
            y += this.yvi[i] * this.vstar[i];
        }
        return y;
    }

    private double rdist(double[] x1, double[] x2) {
        double d = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            double t = x1[i] - x2[i];
            d += t * t;
        }
        return Math.sqrt(d);
    }
}

