/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.feature.SparseOneHotEncoder;

public class SparseOneHotEncoderTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testFeature() {
        System.out.println("feature");
        int[][] result = new int[][]{{0, 3, 6, 9}, {0, 3, 6, 8}, {1, 3, 6, 9}, {2, 4, 6, 9}, {2, 5, 7, 9}, {2, 5, 7, 8}, {1, 5, 7, 8}, {0, 4, 6, 9}, {0, 5, 7, 9}, {2, 4, 7, 9}, {0, 4, 7, 8}, {1, 4, 6, 8}, {1, 3, 7, 9}, {2, 4, 6, 8}};
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset weather = arffParser.parse(IOUtils.getTestDataFile("weka/weather.nominal.arff"));
            double[][] x = (double[][])weather.toArray((E[])new double[weather.size()][]);
            SparseOneHotEncoder n2sb = new SparseOneHotEncoder(weather.attributes());
            for (int i = 0; i < x.length; ++i) {
                int[] y = n2sb.feature(x[i]);
                Assert.assertEquals(result[i].length, y.length);
                for (int j = 0; j < y.length; ++j) {
                    Assert.assertEquals(result[i][j], y[j]);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

