/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.feature.FeatureTransform;
import smile.math.Math;

public class MaxAbsScaler
extends FeatureTransform {
    private double[] scale;

    public MaxAbsScaler() {
    }

    public MaxAbsScaler(boolean copy) {
        super(copy);
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        int i;
        int n = data.length;
        int p = data[0].length;
        this.scale = new double[p];
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                double abs;
                if (attributes[j].getType() != Attribute.Type.NUMERIC || !(this.scale[j] < (abs = Math.abs(data[i][j])))) continue;
                this.scale[j] = abs;
            }
        }
        for (i = 0; i < this.scale.length; ++i) {
            if (!Math.isZero(this.scale[i])) continue;
            this.scale[i] = 1.0;
        }
    }

    @Override
    public double[] transform(double[] x) {
        if (x.length != this.scale.length) {
            throw new IllegalArgumentException(String.format("Invalid vector size %d, expected %d", x.length, this.scale.length));
        }
        double[] y = this.copy ? new double[x.length] : x;
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i] / this.scale[i];
        }
        return y;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MaxAbsScaler(");
        if (this.scale != null) {
            if (this.scale.length > 0) {
                sb.append(String.format("%.4f", this.scale[0]));
            }
            for (int i = 1; i < this.scale.length; ++i) {
                sb.append(String.format(", %.4f", this.scale[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

