/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.ExponentialDistribution;

public class ExponentialDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider lambdaSlider;
    private double lambda = 1.0;

    public ExponentialDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 50; i += 10) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i / 10)));
        }
        this.lambdaSlider = new JSlider(0, 50, (int)Math.round(this.lambda * 10.0));
        this.lambdaSlider.addChangeListener(this);
        this.lambdaSlider.setLabelTable(labelTable);
        this.lambdaSlider.setMajorTickSpacing(10);
        this.lambdaSlider.setMinorTickSpacing(2);
        this.lambdaSlider.setPaintTicks(true);
        this.lambdaSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("\u03bb:"));
        this.optionPane.add(this.lambdaSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        ExponentialDistribution dist = new ExponentialDistribution(this.lambda);
        double[][] p = new double[100][2];
        double[][] q = new double[100][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)i / 20.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)i / 20.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.lambdaSlider) {
            this.lambda = (double)this.lambdaSlider.getValue() / 10.0;
            if (this.lambda == 0.0) {
                this.lambda = 0.01;
            }
            ExponentialDistribution dist = new ExponentialDistribution(this.lambda);
            double[][] p = new double[100][2];
            double[][] q = new double[100][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)i / 20.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)i / 20.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "Exponential";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Exponential Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new ExponentialDistributionDemo());
        frame.setVisible(true);
    }
}

