/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.ChiSquareDistribution;

public class ChiSquareDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider kSlider;
    private int k = 10;

    public ChiSquareDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(1, new JLabel(String.valueOf(1)));
        for (int i = 5; i <= 20; i += 5) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.kSlider = new JSlider(0, 20, this.k);
        this.kSlider.addChangeListener(this);
        this.kSlider.setLabelTable(labelTable);
        this.kSlider.setMajorTickSpacing(5);
        this.kSlider.setMinorTickSpacing(1);
        this.kSlider.setPaintTicks(true);
        this.kSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("Degree of Freedom:"));
        this.optionPane.add(this.kSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        ChiSquareDistribution dist = new ChiSquareDistribution(this.k);
        double[][] p = new double[100][2];
        double[][] q = new double[100][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)i / 2.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)i / 2.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.kSlider) {
            this.k = this.kSlider.getValue();
            if (this.k == 0) {
                this.k = 1;
            }
            ChiSquareDistribution dist = new ChiSquareDistribution(this.k);
            double[][] p = new double[100][2];
            double[][] q = new double[100][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)i / 2.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)i / 2.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "ChiSquare";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ChiSquare Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new ChiSquareDistributionDemo());
        frame.setVisible(true);
    }
}

