/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.neighbor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.LSH;
import smile.neighbor.LinearSearch;
import smile.neighbor.MPLSH;
import smile.neighbor.Neighbor;
import smile.plot.BarPlot;
import smile.plot.PlotCanvas;

public class RNNSearchDemo
extends JPanel
implements Runnable,
ActionListener {
    private String[] label = new String[]{"Naive", "KD-Tree", "Cover Tree", "LSH", "MPLSH"};
    private JPanel optionPane;
    private JPanel canvas;
    private JButton startButton = new JButton("Start");
    private JSlider logNSlider;
    private JSlider dimensionSlider;
    private JTextField radiusField;
    private int logN = 4;
    private int dimension = 10;
    private double radius = 0.5;

    public RNNSearchDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        Hashtable<Integer, JLabel> logNLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 3; i <= 7; ++i) {
            logNLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.logNSlider = new JSlider(3, 7, this.logN);
        this.logNSlider.setLabelTable(logNLabelTable);
        this.logNSlider.setMajorTickSpacing(1);
        this.logNSlider.setPaintTicks(true);
        this.logNSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> dimensionLabelTable = new Hashtable<Integer, JLabel>();
        dimensionLabelTable.put(new Integer(2), new JLabel(String.valueOf(2)));
        for (int i = 20; i <= 120; i += 20) {
            dimensionLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.dimensionSlider = new JSlider(2, 128, this.dimension);
        this.dimensionSlider.setLabelTable(dimensionLabelTable);
        this.dimensionSlider.setMajorTickSpacing(20);
        this.dimensionSlider.setMinorTickSpacing(5);
        this.dimensionSlider.setPaintTicks(true);
        this.dimensionSlider.setPaintLabels(true);
        this.radiusField = new JTextField(Double.toString(this.radius), 5);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("log N:"));
        this.optionPane.add(this.logNSlider);
        this.optionPane.add(new JLabel("Dimension:"));
        this.optionPane.add(this.dimensionSlider);
        this.optionPane.add(new JLabel("Radius:"));
        this.optionPane.add(this.radiusField);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 2));
        this.canvas.setBackground(Color.WHITE);
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.logNSlider.setEnabled(false);
        this.dimensionSlider.setEnabled(false);
        this.radiusField.setEnabled(false);
        this.logN = this.logNSlider.getValue();
        this.dimension = this.dimensionSlider.getValue();
        System.out.println("Generating dataset...");
        int n = (int)Math.pow(10.0, (double)this.logN);
        double[][] data = new double[n][];
        for (int i = 0; i < n; ++i) {
            data[i] = new double[this.dimension];
            for (int j = 0; j < this.dimension; ++j) {
                data[i][j] = Math.random();
            }
        }
        int[] perm = Math.permutate(n);
        System.out.println("Building searching data structure...");
        long time = System.currentTimeMillis();
        LinearSearch<double[]> naive = new LinearSearch<double[]>(data, new EuclideanDistance());
        int naiveBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        KDTree<double[]> kdtree = new KDTree<double[]>(data, (E[])data);
        int kdtreeBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        CoverTree<double[]> cover = new CoverTree<double[]>(data, new EuclideanDistance());
        int coverBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        LSH<Object> lsh = new LSH<Object>(this.dimension, 5, (int)Math.log2(this.dimension), 4.0 * this.radius, 1017881);
        for (int i = 0; i < n; ++i) {
            lsh.put(data[i], data[i]);
        }
        int lshBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        MPLSH<Object> mplsh = new MPLSH<Object>(this.dimension, 3, (int)Math.log2(n), 4.0 * this.radius, 1017881);
        for (int i = 0; i < n; ++i) {
            mplsh.put(data[i], data[i]);
        }
        double[][] train = new double[1000][];
        for (int i = 0; i < train.length; ++i) {
            train[i] = data[perm[i]];
        }
        mplsh.learn(kdtree, train, this.radius);
        int mplshBuild = (int)(System.currentTimeMillis() - time);
        System.out.println("Perform 1000 searches...");
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList neighbors = new ArrayList();
            naive.range(data[perm[i]], this.radius, neighbors);
        }
        int naiveSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList neighbors = new ArrayList();
            kdtree.range(data[perm[i]], this.radius, (List<Neighbor<double[], double[]>>)neighbors);
        }
        int kdtreeSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList neighbors = new ArrayList();
            cover.range(data[perm[i]], this.radius, neighbors);
        }
        int coverSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList neighbors = new ArrayList();
            lsh.range(data[perm[i]], this.radius, (List<Neighbor<double[], Object>>)neighbors);
        }
        int lshSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList neighbors = new ArrayList();
            mplsh.range(data[perm[i]], this.radius, neighbors, 0.95, 10);
        }
        int mplshSearch = (int)(System.currentTimeMillis() - time);
        this.canvas.removeAll();
        double[] buildTime = new double[]{naiveBuild, kdtreeBuild, coverBuild, lshBuild, mplshBuild};
        PlotCanvas build = BarPlot.plot(buildTime, this.label);
        build.setTitle("Build Time");
        this.canvas.add(build);
        double[] searchTime = new double[]{naiveSearch, kdtreeSearch, coverSearch, lshSearch, mplshSearch};
        PlotCanvas search = BarPlot.plot(searchTime, this.label);
        search.setTitle("Search Time");
        this.canvas.add(search);
        this.validate();
        this.startButton.setEnabled(true);
        this.logNSlider.setEnabled(true);
        this.dimensionSlider.setEnabled(true);
        this.radiusField.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            try {
                this.radius = Double.parseDouble(this.radiusField.getText().trim());
                if (this.radius <= 0.0) {
                    JOptionPane.showMessageDialog(this, "Invalid Radius: " + this.radius, "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid Radius: " + this.radiusField.getText(), "Error", 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "Range Search";
    }

    public static void main(String[] argv) {
        RNNSearchDemo demo = new RNNSearchDemo();
        JFrame f = new JFrame("Range Search");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

