/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.manifold;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.manifold.TSNE;
import smile.math.Math;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.projection.PCA;

public class TSNEDemo
extends JPanel
implements Runnable,
ActionListener {
    int perplexity = 20;
    JTextField perplexityField;
    private static String[] datasetName = new String[]{"MNIST"};
    double[][] data;
    int[] labels;
    JPanel optionPane;
    JComponent canvas;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    char pointLegend = (char)64;

    public TSNEDemo() {
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.perplexityField = new JTextField(Integer.toString(this.perplexity), 5);
        this.optionPane.add(new JLabel("Perplexity:"));
        this.optionPane.add(this.perplexityField);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
    }

    public JComponent learn() {
        JPanel pane = new JPanel(new GridLayout(1, 2));
        PCA pca = new PCA(this.data);
        pca.setProjection(50);
        double[][] X = pca.project(this.data);
        long clock = System.currentTimeMillis();
        TSNE tsne = new TSNE(X, 2, this.perplexity, 200.0, 1000);
        System.out.format("Learn t-SNE from %d samples in %dms\n", this.data.length, System.currentTimeMillis() - clock);
        double[][] y = tsne.getCoordinates();
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        for (int i = 0; i < y.length; ++i) {
            plot.point(this.pointLegend, Palette.COLORS[this.labels[i]], y[i]);
        }
        plot.setTitle("tSNE");
        pane.add(plot);
        return pane;
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        this.perplexityField.setEnabled(false);
        try {
            JComponent plot = this.learn();
            if (plot != null) {
                if (this.canvas != null) {
                    this.remove(this.canvas);
                }
                this.canvas = plot;
                this.add((Component)plot, "Center");
            }
            this.validate();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
        this.perplexityField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            DelimitedTextParser parser = new DelimitedTextParser();
            try {
                AttributeDataset dataset = parser.parse(IOUtils.getTestDataFile("mnist/mnist2500_X.txt"));
                this.data = (double[][])dataset.toArray((E[])new double[dataset.size()][]);
                dataset = parser.parse(IOUtils.getTestDataFile("mnist/mnist2500_labels.txt"));
                this.labels = new int[dataset.size()];
                for (int i = 0; i < this.labels.length; ++i) {
                    this.labels[i] = (int)((double[])dataset.get((int)i).x)[0];
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                System.err.println(ex);
            }
            try {
                this.perplexity = Integer.parseInt(this.perplexityField.getText().trim());
                if (this.perplexity < 10 || this.perplexity > 300) {
                    JOptionPane.showMessageDialog(this, "Invalid Perplexity: " + this.perplexity, "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.perplexityField.getText(), "Error", 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "t-SNE";
    }

    public static void main(String[] argv) {
        TSNEDemo demo = new TSNEDemo();
        JFrame f = new JFrame("t-SNE");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

