/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.demo.clustering.ClusteringDemo;
import smile.math.Math;
import smile.plot.Hexmap;
import smile.plot.Histogram;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;
import smile.stat.distribution.GaussianMixture;
import smile.vq.SOM;

public class SOMDemo
extends ClusteringDemo {
    JTextField widthField = new JTextField(Integer.toString(this.width), 10);
    JTextField heightField;
    int width = 10;
    int height = 10;

    public SOMDemo() {
        this.optionPane.add(new JLabel("Width:"));
        this.optionPane.add(this.widthField);
        this.heightField = new JTextField(Integer.toString(this.height), 10);
        this.optionPane.add(new JLabel("Height:"));
        this.optionPane.add(this.heightField);
    }

    @Override
    public JComponent learn() {
        int i;
        try {
            this.width = Integer.parseInt(this.widthField.getText().trim());
            if (this.width < 1) {
                JOptionPane.showMessageDialog(this, "Invalid width: " + this.width, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid width: " + this.widthField.getText(), "Error", 0);
            return null;
        }
        try {
            this.height = Integer.parseInt(this.heightField.getText().trim());
            if (this.height < 1) {
                JOptionPane.showMessageDialog(this, "Invalid height: " + this.height, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid height: " + this.heightField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        SOM som = new SOM(dataset[datasetIndex], this.width, this.height);
        System.out.format("SOM clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        JPanel pane = new JPanel(new GridLayout(2, 3));
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        plot.grid(som.map());
        plot.setTitle("SOM Grid");
        pane.add(plot);
        int[] membership = som.partition(clusterNumber);
        int[] clusterSize = new int[clusterNumber];
        for (int i2 = 0; i2 < membership.length; ++i2) {
            int n = membership[i2];
            clusterSize[n] = clusterSize[n] + 1;
        }
        plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        plot.setTitle("Hierarchical Clustering");
        for (int k = 0; k < clusterNumber; ++k) {
            double[][] cluster = new double[clusterSize[k]][];
            int j = 0;
            for (i = 0; i < dataset[datasetIndex].length; ++i) {
                if (membership[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        pane.add(plot);
        double[][] umatrix = som.umatrix();
        double[] umatrix1 = new double[umatrix.length * umatrix[0].length];
        int k = 0;
        for (i = 0; i < umatrix.length; ++i) {
            int j = 0;
            while (j < umatrix[i].length) {
                umatrix1[k] = umatrix[i][j];
                ++j;
                ++k;
            }
        }
        plot = Histogram.plot(null, umatrix1, 20);
        plot.setTitle("U-Matrix Histogram");
        pane.add(plot);
        GaussianMixture mixture = new GaussianMixture(umatrix1);
        double w = (Math.max(umatrix1) - Math.min(umatrix1)) / 24.0;
        double[][] p = new double[50][2];
        for (int i3 = 0; i3 < p.length; ++i3) {
            p[i3][0] = Math.min(umatrix1) + (double)i3 * w;
            p[i3][1] = mixture.p(p[i3][0]) * w;
        }
        plot.line(p, Color.RED);
        plot = Hexmap.plot(umatrix, Palette.jet(256));
        plot.setTitle("U-Matrix");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "SOM";
    }

    public static void main(String[] argv) {
        SOMDemo demo = new SOMDemo();
        JFrame f = new JFrame("SOM");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

