/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.GMeans;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class GMeansDemo
extends ClusteringDemo {
    JTextField maxClusterNumberField;
    int maxClusterNumber = 50;

    public GMeansDemo() {
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.maxClusterNumberField = new JTextField(Integer.toString(this.maxClusterNumber), 5);
        this.optionPane.add(new JLabel("Max K:"));
        this.optionPane.add(this.maxClusterNumberField);
    }

    @Override
    public JComponent learn() {
        try {
            this.maxClusterNumber = Integer.parseInt(this.maxClusterNumberField.getText().trim());
            if (this.maxClusterNumber < 2) {
                JOptionPane.showMessageDialog(this, "Invalid Max K: " + this.maxClusterNumber, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid Max K: " + this.maxClusterNumberField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        GMeans gmeans = new GMeans(dataset[datasetIndex], this.maxClusterNumber);
        System.out.format("G-Means clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(gmeans.centroids(), '@');
        for (int k = 0; k < gmeans.getNumClusters(); ++k) {
            if (gmeans.getClusterSize()[k] <= 0) continue;
            double[][] cluster = new double[gmeans.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (gmeans.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points(gmeans.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "G-Means";
    }

    public static void main(String[] argv) {
        GMeansDemo demo = new GMeansDemo();
        JFrame f = new JFrame("G-Means");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

