/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.classification.KNN;
import smile.demo.classification.ClassificationDemo;

public class KNNDemo
extends ClassificationDemo {
    private int k = 1;
    private JTextField kField = new JTextField(Integer.toString(this.k), 5);

    public KNNDemo() {
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.kField);
    }

    @Override
    public double[][] learn(double[] x, double[] y) {
        try {
            this.k = Integer.parseInt(this.kField.getText().trim());
            if (this.k < 1) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.k, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid K: " + this.kField.getText(), "Error", 0);
            return null;
        }
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        KNN<double[]> knn = KNN.learn(data, label, this.k);
        int[] pred = new int[label.length];
        for (int i = 0; i < label.length; ++i) {
            pred[i] = knn.predict(data[i]);
        }
        double trainError = this.error(pred, label);
        System.out.format("training error = %.2f%%\n", 100.0 * trainError);
        double[][] z = new double[y.length][x.length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double[] p = new double[]{x[j], y[i]};
                z[i][j] = knn.predict(p);
            }
        }
        return z;
    }

    @Override
    public String toString() {
        return "K Nearest Neighbors";
    }

    public static void main(String[] argv) {
        KNNDemo demo = new KNNDemo();
        JFrame f = new JFrame("K Nearest Neighbors");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

