/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import smile.data.Attribute;
import smile.data.Datum;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.matrix.SparseMatrix;

public class SparseDataset
implements Iterable<Datum<SparseArray>> {
    private String name;
    private String description;
    private Attribute response = null;
    private List<Datum<SparseArray>> data = new ArrayList<Datum<SparseArray>>();
    private int n;
    private int numColumns;
    private int[] colSize;

    public SparseDataset() {
        this("Sparse Dataset");
    }

    public SparseDataset(String name) {
        this(name, null);
    }

    public SparseDataset(Attribute response) {
        this("SparseDataset", response);
    }

    public SparseDataset(String name, Attribute response) {
        this.name = name;
        this.response = response;
        this.numColumns = 0;
        this.colSize = new int[100];
    }

    public SparseDataset(int ncols) {
        this.numColumns = ncols;
        this.colSize = new int[ncols];
    }

    public SparseDataset(int ncols, Attribute response) {
        this.numColumns = ncols;
        this.colSize = new int[ncols];
        this.response = response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute response() {
        return this.response;
    }

    public int size() {
        return this.data.size();
    }

    public int ncols() {
        return this.numColumns;
    }

    public int length() {
        return this.n;
    }

    public void set(int i, int y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        if (i < 0) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int nrows = this.size();
        if (i >= nrows) {
            for (int k = nrows; k <= i; ++k) {
                this.data.add(new Datum<SparseArray>(new SparseArray()));
            }
        }
        this.get((int)i).y = y;
    }

    public void set(int i, double y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric.");
        }
        if (i < 0) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int nrows = this.size();
        if (i >= nrows) {
            for (int k = nrows; k <= i; ++k) {
                this.data.add(new Datum<SparseArray>(new SparseArray()));
            }
        }
        this.get((int)i).y = y;
    }

    public void set(int i, double y, double weight) {
        if (i < 0) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int nrows = this.size();
        if (i >= nrows) {
            for (int k = nrows; k <= i; ++k) {
                this.data.add(new Datum<SparseArray>(new SparseArray()));
            }
        }
        Datum<SparseArray> datum = this.get(i);
        datum.y = y;
        datum.weight = weight;
    }

    public void set(int i, int j, double x) {
        if (i < 0 || j < 0) {
            throw new IllegalArgumentException("Invalid index: i = " + i + " j = " + j);
        }
        int nrows = this.size();
        if (i >= nrows) {
            for (int k = nrows; k <= i; ++k) {
                this.data.add(new Datum<SparseArray>(new SparseArray()));
            }
        }
        if (j >= this.ncols()) {
            this.numColumns = j + 1;
            if (this.numColumns > this.colSize.length) {
                int[] size = new int[3 * this.numColumns / 2];
                System.arraycopy(this.colSize, 0, size, 0, this.colSize.length);
                this.colSize = size;
            }
        }
        if (((SparseArray)this.get((int)i).x).set(j, x)) {
            int n = j;
            this.colSize[n] = this.colSize[n] + 1;
            ++this.n;
        }
    }

    public Datum<SparseArray> get(int i) {
        return this.data.get(i);
    }

    public double get(int i, int j) {
        if (i < 0 || i >= this.size() || j < 0 || j >= this.ncols()) {
            throw new IllegalArgumentException("Invalid index: i = " + i + " j = " + j);
        }
        for (SparseArray.Entry e : (SparseArray)this.get((int)i).x) {
            if (e.i != j) continue;
            return e.x;
        }
        return 0.0;
    }

    public Datum<SparseArray> remove(int i) {
        Datum<SparseArray> datum = this.data.remove(i);
        this.n -= ((SparseArray)datum.x).size();
        for (SparseArray.Entry item : (SparseArray)datum.x) {
            int n = item.i;
            this.colSize[n] = this.colSize[n] - 1;
        }
        return datum;
    }

    public void unitize() {
        for (Datum<SparseArray> row : this) {
            double sum = 0.0;
            for (SparseArray.Entry e : (SparseArray)row.x) {
                sum += Math.sqr(e.x);
            }
            sum = Math.sqrt(sum);
            for (SparseArray.Entry e : (SparseArray)row.x) {
                e.x /= sum;
            }
        }
    }

    public void unitize1() {
        for (Datum<SparseArray> row : this) {
            double sum = 0.0;
            for (SparseArray.Entry e : (SparseArray)row.x) {
                sum += Math.abs(e.x);
            }
            for (SparseArray.Entry e : (SparseArray)row.x) {
                e.x /= sum;
            }
        }
    }

    public SparseMatrix toSparseMatrix() {
        int[] pos = new int[this.numColumns];
        int[] colIndex = new int[this.numColumns + 1];
        for (int i = 0; i < this.numColumns; ++i) {
            colIndex[i + 1] = colIndex[i] + this.colSize[i];
        }
        int nrows = this.size();
        int[] rowIndex = new int[this.n];
        double[] x = new double[this.n];
        for (int i = 0; i < nrows; ++i) {
            for (SparseArray.Entry e : (SparseArray)this.get((int)i).x) {
                int j = e.i;
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = e.x;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrows, this.numColumns, x, rowIndex, colIndex);
    }

    @Override
    public Iterator<Datum<SparseArray>> iterator() {
        return new Iterator<Datum<SparseArray>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseDataset.this.data.size();
            }

            @Override
            public Datum<SparseArray> next() {
                return SparseDataset.this.get(this.i++);
            }

            @Override
            public void remove() {
                SparseDataset.this.remove(this.i);
            }
        };
    }

    public double[][] toArray() {
        int m = this.data.size();
        double[][] a = new double[m][this.ncols()];
        for (int i = 0; i < m; ++i) {
            for (SparseArray.Entry item : (SparseArray)this.get((int)i).x) {
                a[i][item.i] = item.x;
            }
        }
        return a;
    }

    public SparseArray[] toArray(SparseArray[] a) {
        int i;
        int m = this.data.size();
        if (a.length < m) {
            a = new SparseArray[m];
        }
        for (i = 0; i < m; ++i) {
            a[i] = (SparseArray)this.get((int)i).x;
        }
        for (i = m; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    public int[] toArray(int[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        int m = this.data.size();
        if (a.length < m) {
            a = new int[m];
        }
        for (i = 0; i < m; ++i) {
            Datum<SparseArray> datum = this.get(i);
            a[i] = Double.isNaN(datum.y) ? Integer.MIN_VALUE : (int)this.get((int)i).y;
        }
        for (i = m; i < a.length; ++i) {
            a[i] = Integer.MIN_VALUE;
        }
        return a;
    }

    public double[] toArray(double[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric.");
        }
        int m = this.data.size();
        if (a.length < m) {
            a = new double[m];
        }
        for (i = 0; i < m; ++i) {
            a[i] = this.get((int)i).y;
        }
        for (i = m; i < a.length; ++i) {
            a[i] = Double.NaN;
        }
        return a;
    }
}

