/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import smile.association.FPGrowth;
import smile.association.ItemSet;

class TotalSupportTree {
    Node root = new Node();
    private int[] order;
    private int minSupport;

    public TotalSupportTree(int minSupport, int numItems, int[] order) {
        this.minSupport = minSupport;
        this.order = order;
        this.root.children = new Node[numItems];
    }

    public void add(int[] itemset, int support) {
        this.add(this.root, 0, itemset.length - 1, itemset, support);
    }

    private void add(Node node, int size, int index, int[] itemset, int support) {
        int item;
        if (node.children == null) {
            node.children = new Node[size];
        }
        if (node.children[item = this.order[itemset[index]]] == null) {
            node.children[item] = new Node(itemset[index]);
        }
        if (index == 0) {
            node.children[item].support += support;
        } else {
            this.add(node.children[item], item, index - 1, itemset, support);
        }
    }

    public int getSupport(int[] itemset) {
        if (this.root.children != null) {
            return this.getSupport(itemset, itemset.length - 1, this.root);
        }
        return 0;
    }

    private int getSupport(int[] itemset, int index, Node node) {
        int item = this.order[itemset[index]];
        Node child = node.children[item];
        if (child != null) {
            if (index == 0) {
                return child.support;
            }
            if (child.children != null) {
                return this.getSupport(itemset, index - 1, child);
            }
        }
        return 0;
    }

    public List<ItemSet> getFrequentItemsets() {
        ArrayList<ItemSet> list = new ArrayList<ItemSet>();
        this.getFrequentItemsets(null, list);
        return list;
    }

    public long getFrequentItemsets(PrintStream out) {
        return this.getFrequentItemsets(out, null);
    }

    private long getFrequentItemsets(PrintStream out, List<ItemSet> list) {
        long n = 0L;
        if (this.root.children != null) {
            for (int i = 0; i < this.root.children.length; ++i) {
                Node child = this.root.children[i];
                if (child == null || child.support < this.minSupport) continue;
                int[] itemset = new int[]{child.id};
                n += this.getFrequentItemsets(out, list, itemset, i, child);
            }
        }
        return n;
    }

    private long getFrequentItemsets(PrintStream out, List<ItemSet> list, int[] itemset, int size, Node node) {
        ItemSet set = new ItemSet(itemset, node.support);
        if (out != null) {
            out.println(set);
        }
        if (list != null) {
            list.add(set);
        }
        long n = 1L;
        if (node.children != null) {
            for (int i = 0; i < size; ++i) {
                Node child = node.children[i];
                if (child == null || child.support < this.minSupport) continue;
                int[] newItemset = FPGrowth.insert(itemset, child.id);
                n += this.getFrequentItemsets(out, list, newItemset, i, child);
            }
        }
        return n;
    }

    class Node {
        int id = -1;
        int support = 0;
        Node[] children = null;

        Node() {
        }

        Node(int id) {
            this.id = id;
        }
    }
}

