/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.IRingBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBufferArrayFast<T>
implements Cloneable,
IRingBuffer<T> {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = 3834590997991404595L;
    protected Object[] m_buffer;
    protected boolean m_empty = true;
    protected int m_headpointer = 0;
    protected int m_size;
    protected int m_tailpointer = 0;

    public RingBufferArrayFast(int aSize) {
        this.m_buffer = new Object[aSize];
        this.m_size = aSize - 1;
    }

    @Override
    public T add(T anObject) {
        Object ret = null;
        if (this.isFull()) {
            ret = this.m_buffer[this.m_tailpointer];
            this.incTail();
        }
        this.m_buffer[this.m_headpointer] = anObject;
        this.incHead();
        return (T)ret;
    }

    @Override
    public void clear() {
        this.m_headpointer = 0;
        this.m_tailpointer = 0;
        this.m_empty = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RingBufferArrayFast other = (RingBufferArrayFast)obj;
        if (!Arrays.equals(this.m_buffer, other.m_buffer)) {
            return false;
        }
        if (this.m_empty != other.m_empty) {
            return false;
        }
        if (this.m_headpointer != other.m_headpointer) {
            return false;
        }
        if (this.m_size != other.m_size) {
            return false;
        }
        return this.m_tailpointer == other.m_tailpointer;
    }

    @Override
    public int getBufferSize() {
        return this.m_size + 1;
    }

    @Override
    public T getOldest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        return (T)this.m_buffer[this.m_tailpointer];
    }

    @Override
    public T getYoungest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        int tmp = this.m_headpointer;
        tmp = tmp == 0 ? this.m_size : --tmp;
        return (T)this.m_buffer[tmp];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_buffer);
        result = 31 * result + (this.m_empty ? 1231 : 1237);
        result = 31 * result + this.m_headpointer;
        result = 31 * result + this.m_size;
        result = 31 * result + this.m_tailpointer;
        return result;
    }

    private void incHead() {
        this.m_headpointer = this.m_headpointer == this.m_size ? 0 : ++this.m_headpointer;
        this.m_empty = false;
    }

    private void incTail() {
        this.m_tailpointer = this.m_tailpointer == this.m_size ? 0 : ++this.m_tailpointer;
        if (this.m_tailpointer == this.m_headpointer) {
            this.m_empty = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_empty;
    }

    @Override
    public boolean isFull() {
        boolean ret = this.m_headpointer == this.m_tailpointer && !this.m_empty;
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iteratorL2F();
    }

    @Override
    public Iterator<T> iteratorF2L() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArrayFast.this.m_headpointer == 0 ? RingBufferArrayFast.this.size() - 1 : RingBufferArrayFast.this.m_headpointer - 1;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == 0 ? RingBufferArrayFast.this.m_size : --this.m_pos;
            }
        };
    }

    @Override
    public Iterator<T> iteratorL2F() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArrayFast.this.m_tailpointer;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == RingBufferArrayFast.this.m_size ? 0 : ++this.m_pos;
            }
        };
    }

    @Override
    public T remove() {
        if (this.isEmpty()) {
            throw new IRingBuffer.RingBufferException("Buffer is empty.");
        }
        Object ret = null;
        ret = this.m_buffer[this.m_tailpointer];
        this.incTail();
        return (T)ret;
    }

    @Override
    public T[] removeAll() {
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.remove();
        }
        return ret;
    }

    @Override
    public void setBufferSize(int newSize) {
        Object[] newbuffer = new Object[newSize];
        boolean emptyStore = this.m_empty;
        int j = 0;
        int oldSize = this.size();
        int stop = oldSize - newSize;
        for (int i = 0; i < stop && !this.isEmpty(); ++i) {
            this.remove();
        }
        for (j = 0; j < newSize && !this.isEmpty(); ++j) {
            newbuffer[j] = this.remove();
        }
        this.m_tailpointer = 0;
        this.m_headpointer = j;
        if (this.m_headpointer == newSize) {
            this.m_headpointer = 0;
        }
        this.m_buffer = newbuffer;
        this.m_size = newSize - 1;
        this.m_empty = emptyStore || newSize == 0;
    }

    @Override
    public int size() {
        int result = 0;
        result = this.m_empty ? 0 : (this.m_headpointer == this.m_tailpointer ? this.m_size + 1 : (this.m_headpointer > this.m_tailpointer ? this.m_headpointer - this.m_tailpointer : this.m_headpointer + this.m_size + 1 - this.m_tailpointer));
        return result;
    }

    public String toString() {
        String result;
        if (this.isEmpty()) {
            result = "[]";
        } else {
            Object[] actualcontent = new Object[this.size()];
            int tmp = this.m_tailpointer;
            for (int i = 0; i < actualcontent.length; ++i) {
                actualcontent[i] = this.m_buffer[tmp];
                tmp = tmp == this.m_size ? 0 : ++tmp;
                if (tmp == this.m_headpointer && this.m_empty) break;
            }
            result = StringUtil.arrayToString(actualcontent);
        }
        return result;
    }

    protected abstract class ARingBufferIterator
    implements Iterator<T> {
        protected int m_count;
        protected int m_pos;

        ARingBufferIterator() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ARingBufferIterator other = (ARingBufferIterator)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.m_count != other.m_count) {
                return false;
            }
            return this.m_pos == other.m_pos;
        }

        private RingBufferArrayFast<T> getOuterType() {
            return RingBufferArrayFast.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.m_count;
            result = 31 * result + this.m_pos;
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.m_count < RingBufferArrayFast.this.size();
        }

        protected abstract void incPos();

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = RingBufferArrayFast.this.m_buffer[this.m_pos];
            ++this.m_count;
            this.incPos();
            if (result == null) {
                throw new NoSuchElementException("RingBufferArrayFast.iteratorF2L returns null: pos:" + this.m_pos + " count: " + this.m_count);
            }
            return result;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

