/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class RingBufferArray<T>
extends RingBufferArrayFast<T> {
    private static final long serialVersionUID = 3977861774055585593L;
    protected List<T> m_pendingremove = new LinkedList<T>();

    public RingBufferArray(int aSize) {
        super(aSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RingBufferArray other = (RingBufferArray)obj;
        return !(this.m_pendingremove == null ? other.m_pendingremove != null : !this.m_pendingremove.equals(other.m_pendingremove));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_pendingremove == null ? 0 : this.m_pendingremove.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.m_pendingremove.size() == 0;
    }

    @Override
    public Iterator<T> iteratorF2L() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArray.this.m_headpointer == 0 ? RingBufferArray.this.m_size : RingBufferArray.this.m_headpointer - 1;
                this.m_pendpos = RingBufferArray.this.m_pendingremove.size() - 1;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == 0 ? RingBufferArray.this.m_size : --this.m_pos;
            }
        };
    }

    @Override
    public Iterator<T> iteratorL2F() {
        return new ARingBufferIterator(){
            {
                this.m_pos = RingBufferArray.this.m_tailpointer;
                this.m_pendpos = 0;
            }

            @Override
            protected void incPos() {
                this.m_pos = this.m_pos == RingBufferArray.this.m_size ? 0 : ++this.m_pos;
            }
        };
    }

    @Override
    public T remove() {
        T result = null;
        result = this.m_pendingremove.size() > 0 ? (T)this.m_pendingremove.remove(0) : (T)super.remove();
        return result;
    }

    @Override
    public T[] removeAll() {
        int i;
        Object[] ret = new Object[this.size() + this.m_pendingremove.size()];
        int stop = this.m_pendingremove.size();
        for (i = 0; i < stop; ++i) {
            ret[i] = this.m_pendingremove.remove(0);
        }
        while (i < ret.length) {
            ret[i] = this.remove();
            ++i;
        }
        return ret;
    }

    @Override
    public void setBufferSize(int newSize) {
        int i;
        LinkedList<T> newpending = null;
        if (this.size() > newSize) {
            newpending = new LinkedList<T>();
            int stop = this.size();
            for (i = newSize; i < stop; ++i) {
                T add = this.remove();
                newpending.add(add);
            }
        }
        Object[] newbuffer = new Object[newSize];
        i = 0;
        while (!this.isEmpty()) {
            newbuffer[i] = this.remove();
            ++i;
        }
        this.m_tailpointer = 0;
        this.m_headpointer = newSize == i ? 0 : i;
        this.m_buffer = newbuffer;
        this.m_size = newSize - 1;
        if (newpending != null) {
            this.m_pendingremove = newpending;
        }
    }

    @Override
    public int size() {
        return super.size() + this.m_pendingremove.size();
    }

    @Override
    public String toString() {
        String result;
        if (this.isEmpty()) {
            result = "[]";
        } else {
            int i;
            Object[] actualcontent = new Object[this.size()];
            int tmp = this.m_tailpointer;
            int stop = this.m_pendingremove.size();
            Iterator<T> it = this.m_pendingremove.iterator();
            for (i = 0; i < stop; ++i) {
                actualcontent[i] = it.next();
            }
            while (i < actualcontent.length) {
                actualcontent[i] = this.m_buffer[tmp];
                tmp = tmp == this.m_size ? 0 : ++tmp;
                if (tmp == this.m_headpointer && this.m_empty) break;
                ++i;
            }
            result = StringUtil.arrayToString(actualcontent);
        }
        return result;
    }

    abstract class ARingBufferIterator
    extends RingBufferArrayFast.ARingBufferIterator {
        protected int m_pendpos;

        ARingBufferIterator() {
            super(RingBufferArray.this);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ARingBufferIterator other = (ARingBufferIterator)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.m_pendpos == other.m_pendpos;
        }

        private RingBufferArray<T> getOuterType() {
            return RingBufferArray.this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.m_pendpos;
            return result;
        }

        @Override
        public boolean hasNext() {
            return super.hasNext() || this.m_pendpos >= 0;
        }

        @Override
        protected void incPos() {
        }

        @Override
        public T next() {
            Object ret = null;
            if (this.m_pendpos >= 0) {
                ret = RingBufferArray.this.m_pendingremove.get(this.m_pendpos);
                --this.m_pendpos;
                if (ret == null) {
                    System.out.println("RingBufferArray.iteratorF2L returns null: head:" + RingBufferArray.this.m_headpointer + " tail: " + RingBufferArray.this.m_tailpointer);
                }
            } else {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ret = RingBufferArray.this.m_buffer[this.m_pos];
                ++this.m_count;
                this.incPos();
            }
            return ret;
        }
    }
}

