/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import java.lang.reflect.Array;
import java.util.List;

public final class StringUtil {
    private static StringUtil instance = null;

    public static final String appendSpaces(String s, int count) {
        StringBuffer tmp = new StringBuffer(s);
        for (int i = 0; i < count; ++i) {
            tmp.append(" ");
        }
        return tmp.toString();
    }

    public static final void listOfArraysToString(List<Object> objects) {
        if (objects == null) {
            return;
        }
        int stop = objects.size();
        for (int i = 0; i < stop; ++i) {
            objects.add(i, StringUtil.arrayToString(objects.remove(i)));
        }
    }

    public static final String arrayToString(Object isArr) {
        String result = StringUtil.arrayToString(isArr, ",");
        return result;
    }

    public static final String arrayToString(Object isArr, String separator) {
        String result;
        if (isArr == null) {
            result = "null";
        } else {
            StringBuffer tmp = new StringBuffer();
            try {
                int length = Array.getLength(isArr);
                tmp.append("[");
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(isArr, i);
                    if (element == null) {
                        tmp.append("null");
                    } else {
                        tmp.append(element.toString());
                    }
                    if (i >= length - 1) continue;
                    tmp.append(separator);
                }
                tmp.append("]");
                result = tmp.toString();
            }
            catch (ArrayIndexOutOfBoundsException bound) {
                tmp.append("]");
                result = tmp.toString();
            }
            catch (IllegalArgumentException noarr) {
                result = isArr.toString();
            }
        }
        return result;
    }

    public static String getNewLine() {
        return System.getProperty("line.separator");
    }

    public static StringUtil instance() {
        if (instance == null) {
            instance = new StringUtil();
        }
        return instance;
    }

    public static boolean isEmpty(String test) {
        boolean result = test == null ? true : test.trim().length() == 0;
        return result;
    }

    public static final int longestStringRepresentation(List<Object> objects) {
        int result;
        if (objects == null) {
            result = 0;
        } else {
            int maxsize = 0;
            int tint = 0;
            int stop = objects.size();
            for (int i = 0; i < stop; ++i) {
                String tmp = StringUtil.arrayToString(objects.get(i));
                tint = tmp.length();
                if (tint <= maxsize) continue;
                maxsize = tint;
            }
            result = maxsize;
        }
        return result;
    }

    public static final String setSize(String s, int length) {
        String result = s;
        int oldlen = s.length();
        if (oldlen > length) {
            System.err.println("greenpeace.util.setSize(String s,int length): length (" + length + ") is smaller than s.length(" + oldlen + ") : " + s);
        } else {
            int tofill = length - oldlen;
            result = StringUtil.appendSpaces(s, tofill);
        }
        return result;
    }

    public static final void toLongestString(List<Object> objects) {
        int i;
        if (objects == null) {
            return;
        }
        int maxsize = 0;
        int tint = 0;
        int stop = objects.size();
        for (i = 0; i < stop; ++i) {
            StringUtil.arrayToString(objects.get(i));
            String tmp = (String)objects.get(i);
            tint = tmp.length();
            if (tint > maxsize) {
                maxsize = tint;
            }
            objects.add(i, tmp);
        }
        for (i = 0; i < stop; ++i) {
            objects.add(i, StringUtil.setSize((String)objects.remove(i), maxsize));
        }
    }

    private StringUtil() {
    }
}

