/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.StringUtil;
import info.monitorenter.util.collections.Entry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class FileUtil {
    private static final ResourceBundle m_bundle = ResourceBundle.getBundle("messages");

    public static Map.Entry<String, String> cutDirectoryInformation(URL path) {
        String suf;
        String pre;
        Entry<String, String> ret = null;
        StringBuffer tmp = new StringBuffer();
        String parse = path.toExternalForm();
        if (parse.endsWith("/")) {
            pre = parse;
            suf = "";
        } else {
            StringTokenizer tokenizer = new StringTokenizer(path.getFile(), "/");
            tmp.append(path.getProtocol());
            tmp.append(":");
            tmp.append(path.getHost());
            pre = "";
            while (tokenizer.hasMoreElements()) {
                tmp.append(pre);
                pre = tokenizer.nextToken();
                tmp.append("/");
            }
            suf = pre;
            pre = tmp.toString();
        }
        ret = new Entry<String, String>(pre, suf);
        return ret;
    }

    public static Map.Entry<String, String> cutDirectoryInformation(String path) {
        StringBuffer dir = new StringBuffer();
        String file = "";
        String fileseparator = System.getProperty("file.separator");
        StringTokenizer tokenizer = new StringTokenizer(path, fileseparator, true);
        int size = tokenizer.countTokens();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("This cannot be a filename: \"" + path + "\"");
            }
        }
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                dir.append(token);
                continue;
            }
            if (new File(path).isFile()) {
                file = token;
                continue;
            }
            dir.append(token);
        }
        return new Entry<String, String>(dir.toString(), file);
    }

    public static Map.Entry<String, String> cutExtension(String filename) {
        String prefix;
        String suffix = null;
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 1) {
            StringBuffer prefCollect = new StringBuffer();
            while (tokenCount > 1) {
                prefCollect.append(tokenizer.nextToken());
                if (--tokenCount <= 1) continue;
                prefCollect.append(".");
            }
            prefix = prefCollect.toString();
            suffix = tokenizer.nextToken();
        } else {
            prefix = filename;
            suffix = "";
        }
        return new Entry<String, String>(prefix, suffix);
    }

    public static String getDefaultFileName(String name) {
        String result;
        File f = new File(name);
        if (!f.exists()) {
            result = f.getAbsolutePath();
        } else {
            Map.Entry<String, String> cut = FileUtil.cutExtension(name);
            String prefix = cut.getKey();
            String suffix = cut.getValue();
            int num = 0;
            while (f.exists()) {
                f = new File(prefix + '_' + num + '.' + suffix);
                ++num;
            }
            result = f.getAbsolutePath();
        }
        return result;
    }

    public static File deriveFile(File source, String suffix, boolean preserveExtension) throws IOException {
        File result = null;
        Map.Entry<String, String> fileNextension = FileUtil.cutExtension(source.getName());
        Map.Entry<String, String> pathNfile = FileUtil.cutDirectoryInformation(source.getAbsolutePath());
        String ending = suffix;
        if (preserveExtension) {
            ending = ending + fileNextension.getValue();
        }
        result = File.createTempFile(fileNextension.getKey(), ending, new File(pathNfile.getKey()));
        return result;
    }

    public static boolean isAllASCII(File f) throws IOException {
        return FileUtil.isAllASCII(new FileInputStream(f));
    }

    public static boolean isAllASCII(InputStream in) throws IOException {
        boolean ret = true;
        int read = -1;
        do {
            if ((read = in.read()) <= 127) continue;
            ret = false;
            break;
        } while (read != -1);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEqual(File document, Charset a, Charset b) throws IOException {
        boolean ret = true;
        FileInputStream aIn = null;
        FileInputStream bIn = null;
        InputStreamReader aReader = null;
        InputStreamReader bReader = null;
        try {
            aIn = new FileInputStream(document);
            bIn = new FileInputStream(document);
            aReader = new InputStreamReader((InputStream)aIn, a);
            bReader = new InputStreamReader((InputStream)bIn, b);
            int readA = -1;
            int readB = -1;
            do {
                if ((readA = aReader.read()) == (readB = bReader.read())) continue;
                ret = false;
                break;
            } while (readA != -1 && readB != -1);
            boolean bl = ret;
            return bl;
        }
        finally {
            if (aReader != null) {
                aReader.close();
            }
            if (bReader != null) {
                bReader.close();
            }
        }
    }

    public static InputStream readCache(File f) throws IOException {
        return new ByteArrayInputStream(FileUtil.readRAM(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRAM(File f) throws IOException {
        int total = (int)f.length();
        byte[] ret = new byte[total];
        try (FileInputStream in = new FileInputStream(f);){
            int offset = 0;
            int read = 0;
            do {
                if ((read = ((InputStream)in).read(ret, offset, total - read)) <= 0) continue;
                offset += read;
            } while (read != -1 && offset != total);
            byte[] byArray = ret;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuplicateLineBreaks(File f) {
        String sep = StringUtil.getNewLine();
        if (!f.exists()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + f.getAbsolutePath() + " does not exist!");
        } else if (f.isDirectory()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + f.getAbsolutePath() + " is a directory!");
        } else {
            FileInputStream inStream = null;
            BufferedInputStream in = null;
            OutputStreamWriter out = null;
            try {
                int tmpread;
                inStream = new FileInputStream(f);
                in = new BufferedInputStream(inStream, 1024);
                StringBuffer result = new StringBuffer();
                while ((tmpread = in.read()) != -1) {
                    result.append((char)tmpread);
                }
                StringTokenizer toke = new StringTokenizer(result.toString(), sep, true);
                result = new StringBuffer();
                int breaks = 0;
                while (toke.hasMoreTokens()) {
                    String tmpstring = toke.nextToken().trim();
                    if (tmpstring.equals("") && breaks > 0) {
                        ++breaks;
                        continue;
                    }
                    if (tmpstring.equals("")) {
                        tmpstring = sep;
                        ++breaks;
                    } else {
                        breaks = 0;
                    }
                    result.append(tmpstring);
                }
                f.delete();
                f.createNewFile();
                out = new FileWriter(f);
                out.write(result.toString());
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException g) {
                g.printStackTrace(System.err);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private FileUtil() {
    }

    public static String formatFilesize(long filesize, Locale locale) {
        long filesizeNormal = Math.abs(filesize);
        String result = Math.abs(filesize) < 1024L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_BYTES_1"), new Long(filesizeNormal)) : (filesizeNormal < 0x100000L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_KBYTES_1"), new Double((double)filesizeNormal / 1024.0)) : (filesizeNormal < 0x40000000L ? MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_MBYTES_1"), new Double((double)filesize / 1048576.0)) : MessageFormat.format(m_bundle.getString("GUI_FILEUTIL_FILESIZE_GBYTES_1"), new Double((double)filesizeNormal / 1.073741824E9))));
        return result;
    }
}

