/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.rangepolicies;

import info.monitorenter.gui.chart.rangepolicies.ARangePolicy;
import info.monitorenter.util.Range;

public final class RangePolicyHighestValues
extends ARangePolicy {
    private static final long serialVersionUID = 3966377720997931343L;
    private final double m_highestValueRangeToShow;

    public RangePolicyHighestValues() {
        this(50);
    }

    public RangePolicyHighestValues(int amountHighestValues) {
        this.m_highestValueRangeToShow = amountHighestValues;
    }

    public RangePolicyHighestValues(Range range, double highestValueRangeToShow) {
        super(range);
        this.m_highestValueRangeToShow = highestValueRangeToShow;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangePolicyHighestValues other = (RangePolicyHighestValues)obj;
        return Double.doubleToLongBits(this.m_highestValueRangeToShow) == Double.doubleToLongBits(other.m_highestValueRangeToShow);
    }

    @Override
    public double getMax(double chartMin, double chartMax) {
        return chartMax;
    }

    @Override
    public double getMin(double chartMin, double chartMax) {
        return Math.max(chartMax - this.m_highestValueRangeToShow, chartMin);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.m_highestValueRangeToShow);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

